/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.EqualsJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrPropertyShape
extends PathPropertyShape {
    private final List<List<PathPropertyShape>> or;
    private static final Logger logger = LoggerFactory.getLogger(OrPropertyShape.class);

    OrPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource or) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.or = OrPropertyShape.toList(connection, or).stream().map(v -> PropertyShape.Factory.getPropertyShapesInner(connection, nodeShape, (Resource)v, this)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        void var10_16;
        void var10_14;
        if (this.deactivated) {
            return null;
        }
        List initialPlanNodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> shape.getPlan(shaclSailConnection, nodeShape, false, null)).filter(Objects::nonNull).collect(Collectors.toList())).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        PlanNodeProvider targetNodesToValidate = overrideTargetNode == null ? new BufferedSplitter(this.unionAll(initialPlanNodes.stream().flatMap(Collection::stream).map(p -> new Unique(new TrimTuple((PlanNode)p, 0, 1))).collect(Collectors.toList()))) : (shaclSailConnection.sail.isCacheSelectNodes() ? new BufferedSplitter(overrideTargetNode.getPlanNode()) : overrideTargetNode);
        List plannodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> {
            if (shaclSailConnection.stats.isBaseSailEmpty()) {
                return shape.getPlan(shaclSailConnection, nodeShape, false, null);
            }
            return shape.getPlan(shaclSailConnection, nodeShape, false, targetNodesToValidate);
        }).filter(Objects::nonNull).collect(Collectors.toList())).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        List iteratorDataTypes = plannodes.stream().flatMap(shapes -> shapes.stream().map(PlanNode::getIteratorDataType)).distinct().collect(Collectors.toList());
        IteratorData iteratorData = (IteratorData)((Object)iteratorDataTypes.get(0));
        if (iteratorDataTypes.size() > 1) {
            iteratorData = IteratorData.aggregated;
        }
        if (iteratorData == IteratorData.tripleBased && this.childrenHasOwnPath()) {
            iteratorData = IteratorData.aggregated;
        }
        if (plannodes.size() == 1) {
            if (iteratorData == IteratorData.tripleBased) {
                LoggingNode loggingNode = new LoggingNode(this.unionAll((List)plannodes.get(0)), "");
            } else {
                if (iteratorData != IteratorData.aggregated) throw new IllegalStateException("Should not get here!");
                LoggingNode loggingNode = new LoggingNode(new Unique(new TrimTuple(this.unionAll((List)plannodes.get(0)), 0, 1)), "");
            }
        } else if (iteratorData == IteratorData.tripleBased) {
            LoggingNode equalsJoin = new LoggingNode(new EqualsJoin(this.unionAll((List)plannodes.get(0)), this.unionAll((List)plannodes.get(1)), true), "");
            for (int i = 2; i < plannodes.size(); ++i) {
                equalsJoin = new LoggingNode(new EqualsJoin(equalsJoin, this.unionAll((List)plannodes.get(i)), true), "");
            }
            LoggingNode loggingNode = new LoggingNode(equalsJoin, "");
        } else {
            if (iteratorData != IteratorData.aggregated) throw new IllegalStateException("Should not get here!");
            LoggingNode innerJoin = new LoggingNode(new InnerJoin(new Unique(new TrimTuple(this.unionAll((List)plannodes.get(0)), 0, 1)), new Unique(new TrimTuple(this.unionAll((List)plannodes.get(1)), 0, 1))).getJoined(BufferedPlanNode.class), "");
            for (int i = 2; i < plannodes.size(); ++i) {
                innerJoin = new LoggingNode(new InnerJoin(innerJoin, new Unique(new TrimTuple(this.unionAll((List)plannodes.get(i)), 0, 1))).getJoined(BufferedPlanNode.class), "");
            }
            LoggingNode loggingNode = new LoggingNode(innerJoin, "");
        }
        if (printPlans) {
            String planAsGraphiz = this.getPlanAsGraphvizDot((PlanNode)var10_14, shaclSailConnection);
            logger.info(planAsGraphiz);
        }
        if (iteratorData != IteratorData.aggregated) return new EnrichWithShape((PlanNode)var10_16, this);
        AggregateIteratorTypeOverride aggregateIteratorTypeOverride = new AggregateIteratorTypeOverride((PlanNode)var10_14);
        return new EnrichWithShape((PlanNode)var10_16, this);
    }

    public boolean childrenHasOwnPath() {
        return this.or.stream().flatMap(a -> a.stream().map(PathPropertyShape::hasOwnPath)).anyMatch(a -> a);
    }

    private PlanNode unionAll(List<PlanNode> planNodes) {
        return new Unique(new UnionNode(planNodes.toArray(new PlanNode[0])));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        return super.requiresEvaluation(addedStatements, removedStatements) || this.or.stream().flatMap(Collection::stream).map(p -> p.requiresEvaluation(addedStatements, removedStatements)).reduce((a, b) -> a != false || b != false).orElse(false) != false;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrPropertyShape that = (OrPropertyShape)o;
        return this.or.equals(that.or);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.or);
    }

    public String toString() {
        return "OrPropertyShape{or=" + OrPropertyShape.toString(this.or) + '}';
    }
}

