/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclProperties {
    private static final Logger logger = LoggerFactory.getLogger(ShaclProperties.class);
    List<Resource> clazz = new ArrayList<Resource>(0);
    List<Resource> or = new ArrayList<Resource>(0);
    List<Resource> and = new ArrayList<Resource>(0);
    Long minCount;
    Long maxCount;
    Resource datatype;
    Resource in;
    Long minLength;
    Long maxLength;
    Resource languageIn;
    Resource nodeKind;
    Resource path;
    Literal minExclusive;
    Literal maxExclusive;
    Literal minInclusive;
    Literal maxInclusive;
    List<String> pattern = new ArrayList<String>(0);
    String flags = "";
    Set<Resource> targetClass = new HashSet<Resource>(0);
    Set<Value> targetNode = new HashSet<Value>(0);
    Set<IRI> targetSubjectsOf = new HashSet<IRI>(0);
    Set<IRI> targetObjectsOf = new HashSet<IRI>(0);
    boolean deactivated = false;
    boolean uniqueLang = false;

    public ShaclProperties(Resource propertyShapeId, SailRepositoryConnection connection) {
        try (Stream<Statement> stream = Iterations.stream(connection.getStatements(propertyShapeId, null, null, new Resource[0]));){
            stream.forEach(statement -> {
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                switch (predicate) {
                    case "http://www.w3.org/ns/shacl#or": {
                        this.or.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#and": {
                        this.and.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#languageIn": {
                        if (this.languageIn != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.languageIn = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#nodeKind": {
                        if (this.nodeKind != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.nodeKind = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#datatype": {
                        if (this.datatype != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.datatype = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minCount": {
                        if (this.minCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxCount": {
                        if (this.maxCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minLength": {
                        if (this.minLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxLength": {
                        if (this.maxLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minExclusive": {
                        if (this.minExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxExclusive": {
                        if (this.maxExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minInclusive": {
                        if (this.minInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxInclusive": {
                        if (this.maxInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#pattern": {
                        this.pattern.add(object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#class": {
                        this.clazz.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetNode": {
                        this.targetNode.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetClass": {
                        this.targetClass.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetSubjectsOf": {
                        this.targetSubjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetObjectsOf": {
                        this.targetObjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#deactivated": {
                        this.deactivated = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#uniqueLang": {
                        this.uniqueLang = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#flags": {
                        this.flags = this.flags + object.stringValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#path": {
                        if (this.path != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.path = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#in": {
                        if (this.in != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.in = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#property": {
                        break;
                    }
                    default: {
                        if (!predicate.startsWith("http://www.w3.org/ns/shacl#")) break;
                        logger.debug("Unsupported SHACL feature detected {} in statement {}", (Object)predicate.replace("http://www.w3.org/ns/shacl#", "sh:"), statement);
                    }
                }
            });
        }
    }
}

