/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.ExternalTypeFilterNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnorderedSelect;

public class TargetClass
extends NodeShape {
    private final Set<Resource> targetClass;

    TargetClass(Resource id, SailRepositoryConnection connection, boolean deactivated, Set<Resource> targetClass) {
        super(id, connection, deactivated);
        this.targetClass = targetClass;
        assert (!this.targetClass.isEmpty());
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        PlanNode parent = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection, this.getQuery("?a", "?c", shaclSailConnection.getRdfsSubClassOfReasoner()), "*"));
        return new TrimTuple(new LoggingNode(parent, ""), 0, 1);
    }

    @Override
    public PlanNode getPlanAddedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode planNode;
        if (this.targetClass.size() == 1) {
            Resource clazz = (Resource)this.targetClass.stream().findAny().get();
            planNode = shaclSailConnection.getCachedNodeFor(new Sort(new UnorderedSelect(shaclSailConnection.getAddedStatements(), null, RDF.TYPE, clazz, UnorderedSelect.OutputPattern.SubjectPredicateObject)));
        } else {
            planNode = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getAddedStatements(), this.getQuery("?a", "?c", null), "*"));
        }
        return new TrimTuple(new LoggingNode(planNode, ""), 0, 1);
    }

    @Override
    public PlanNode getPlanRemovedStatements(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode planNode;
        if (this.targetClass.size() == 1) {
            Resource clazz = (Resource)this.targetClass.stream().findAny().get();
            planNode = shaclSailConnection.getCachedNodeFor(new Sort(new UnorderedSelect(shaclSailConnection.getRemovedStatements(), null, RDF.TYPE, clazz, UnorderedSelect.OutputPattern.SubjectPredicateObject)));
        } else {
            planNode = shaclSailConnection.getCachedNodeFor(new Select(shaclSailConnection.getRemovedStatements(), this.getQuery("?a", "?c", null), "*"));
        }
        return new TrimTuple(planNode, 0, 1);
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return this.targetClass.stream().map(target -> addedStatements.hasStatement(null, RDF.TYPE, (Value)target, false, new Resource[0])).reduce((a, b) -> a != false || b != false).orElseThrow(IllegalStateException::new);
    }

    @Override
    public String getQuery(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        Set<Resource> targets = this.targetClass;
        if (rdfsSubClassOfReasoner != null) {
            targets = new HashSet<Resource>(targets);
            targets = targets.stream().flatMap(target -> rdfsSubClassOfReasoner.backwardsChain((Resource)target).stream()).collect(Collectors.toSet());
        }
        assert (targets.size() >= 1);
        return targets.stream().map(r -> "{ BIND(rdf:type as ?b1) \n BIND(<" + r + "> as " + objectVariable + ") \n " + subjectVariable + " ?b1 " + objectVariable + ". } \n").reduce((l, r) -> l + " UNION " + r).get();
    }

    @Override
    public PlanNode getTargetFilter(NotifyingSailConnection shaclSailConnection, PlanNode parent) {
        return new ExternalTypeFilterNode(shaclSailConnection, this.targetClass, parent, 0, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetClass that = (TargetClass)o;
        return this.targetClass.equals(that.targetClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetClass);
    }

    @Override
    public String toString() {
        return "TargetClass{targetClass=" + Arrays.asList(this.targetClass.toArray()) + '}';
    }
}

