/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.NonUniqueTargetLang;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueLangPropertyShape
extends PathPropertyShape {
    private final boolean uniqueLang;
    private static final Logger logger = LoggerFactory.getLogger(UniqueLangPropertyShape.class);
    private static final ValueFactory vf = SimpleValueFactory.getInstance();

    UniqueLangPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, boolean uniqueLang) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.uniqueLang = uniqueLang;
        assert (uniqueLang) : "uniqueLang should always be true";
    }

    @Override
    public PlanNode getPlan(ShaclSailConnection shaclSailConnection, NodeShape nodeShape, boolean printPlans, PlanNodeProvider overrideTargetNode) {
        if (this.deactivated) {
            return null;
        }
        if (overrideTargetNode != null) {
            LoggingNode relevantTargetsWithPath = new LoggingNode(new BulkedExternalInnerJoin(overrideTargetNode.getPlanNode(), shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false), "");
            NonUniqueTargetLang planNode = new NonUniqueTargetLang(relevantTargetsWithPath);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(planNode, ""), this);
        }
        if (shaclSailConnection.stats.isBaseSailEmpty()) {
            LoggingNode addedTargets = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
            LoggingNode addedByPath = new LoggingNode(super.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
            LoggingNode innerJoin = new LoggingNode(new InnerJoin(addedTargets, addedByPath).getJoined(UnBufferedPlanNode.class), "");
            NonUniqueTargetLang planNode = new NonUniqueTargetLang(innerJoin);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(new LoggingNode(planNode, ""), this);
        }
        LoggingNode addedTargets = new LoggingNode(nodeShape.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
        LoggingNode addedByPath = new LoggingNode(super.getPlanAddedStatements(shaclSailConnection, nodeShape, null), "");
        addedByPath = new LoggingNode(nodeShape.getTargetFilter(shaclSailConnection, addedByPath), "");
        LoggingNode mergeNode = new LoggingNode(new UnionNode(addedTargets, addedByPath), "");
        LoggingNode trimmed = new LoggingNode(new TrimTuple(mergeNode, 0, 1), "");
        LoggingNode allRelevantTargets = new LoggingNode(new Unique(trimmed), "");
        LoggingNode relevantTargetsWithPath = new LoggingNode(new BulkedExternalInnerJoin(allRelevantTargets, shaclSailConnection, this.getPath().getQuery("?a", "?c", null), false), "");
        NonUniqueTargetLang planNode = new NonUniqueTargetLang(relevantTargetsWithPath);
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(planNode, shaclSailConnection);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(new LoggingNode(planNode, ""), this);
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.UniqueLangConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UniqueLangPropertyShape that = (UniqueLangPropertyShape)o;
        return this.uniqueLang == that.uniqueLang;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uniqueLang);
    }

    public String toString() {
        return "UniqueLangPropertyShape{uniqueLang=" + this.uniqueLang + ", path=" + this.getPath() + '}';
    }
}

