/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.UnionIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private List<NodeShape> nodeShapes;
    private NotifyingSailConnection previousStateConnection;
    MemoryStore addedStatements;
    MemoryStore removedStatements;
    private ConcurrentLinkedQueue<SailConnection> connectionsToClose = new ConcurrentLinkedQueue();
    private HashSet<Statement> addedStatementsSet = new HashSet();
    private HashSet<Statement> removedStatementsSet = new HashSet();
    private boolean isShapeRefreshNeeded = false;
    private boolean shapesModifiedInCurrentTransaction = false;
    public final ShaclSail sail;
    public Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean preparedHasRun = false;
    private SailRepositoryConnection shapesRepoConnection;
    private Map<PlanNode, BufferedSplitter> selectNodeCache;
    boolean validating;
    private long stamp;
    ValueComparator valueComparator = new ValueComparator();
    private boolean connectionListenerActive = false;
    private IsolationLevel currentIsolationLevel = null;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, NotifyingSailConnection previousStateConnection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.sail = sail;
        this.setupConnectionListener();
    }

    public NotifyingSailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public SailConnection getAddedStatements() {
        NotifyingSailConnection connection = this.addedStatements.getConnection();
        this.connectionsToClose.add(connection);
        return connection;
    }

    public SailConnection getRemovedStatements() {
        NotifyingSailConnection connection = this.removedStatements.getConnection();
        this.connectionsToClose.add(connection);
        return connection;
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel level) throws SailException {
        this.currentIsolationLevel = level;
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        assert (this.connectionsToClose.size() == 0);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.shapesRepoConnection.begin(level);
            this.previousStateConnection.begin(level);
        }
        boolean bl = this.stats.baseSailEmpty = !this.hasStatement(null, null, null, true, new Resource[0]);
        if (this.stats.baseSailEmpty) {
            this.removeConnectionListener(this);
            this.connectionListenerActive = false;
        } else {
            this.setupConnectionListener();
        }
    }

    private void setupConnectionListener() {
        if (!this.connectionListenerActive && this.sail.isValidationEnabled()) {
            this.addConnectionListener(this);
        }
    }

    private MemoryStore getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel(IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    @Override
    public void commit() throws SailException {
        if (!this.preparedHasRun) {
            this.prepare();
        }
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        this.previousStateConnection.commit();
        super.commit();
        this.shapesRepoConnection.commit();
        if (this.shapesModifiedInCurrentTransaction) {
            this.sail.setNodeShapes(this.nodeShapes);
        }
        if (this.sail.holdsWriteLock(this.stamp)) {
            this.sail.releaseExclusiveWriteLock(this.stamp);
        }
        if (this.sail.isPerformanceLogging()) {
            logger.info("commit() excluding validation and cleanup took {} ms", (Object)(System.currentTimeMillis() - before));
        }
        this.cleanup();
    }

    @Override
    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.stamp = this.sail.acquireExclusiveWriteLock(this.stamp);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.stamp = this.sail.acquireExclusiveWriteLock(this.stamp);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    @Override
    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals(contexts[0])) {
            this.stamp = this.sail.acquireExclusiveWriteLock(this.stamp);
            this.shapesRepoConnection.add(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    @Override
    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.stamp = this.sail.acquireExclusiveWriteLock(this.stamp);
            this.shapesRepoConnection.remove(subj, pred, obj, new Resource[0]);
            this.isShapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws SailException {
        if (Arrays.asList(contexts).contains(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesRepoConnection.clear(new Resource[0]);
            this.isShapeRefreshNeeded = true;
        }
        super.clear(contexts);
    }

    @Override
    public void rollback() throws SailException {
        this.previousStateConnection.rollback();
        this.shapesRepoConnection.rollback();
        super.rollback();
        if (this.shapesModifiedInCurrentTransaction || this.isShapeRefreshNeeded) {
            this.isShapeRefreshNeeded = true;
            this.refreshShapes();
            if (this.shapesModifiedInCurrentTransaction) {
                this.sail.setNodeShapes(this.nodeShapes);
            }
        }
        if (this.sail.holdsWriteLock(this.stamp)) {
            this.sail.releaseExclusiveWriteLock(this.stamp);
        }
        this.cleanup();
    }

    void cleanup() {
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        logger.debug("Cleanup");
        this.connectionsToClose.forEach(SailConnection::close);
        this.connectionsToClose = new ConcurrentLinkedQueue();
        if (this.addedStatements != null) {
            if (this.addedStatements != this.sail.getBaseSail()) {
                this.addedStatements.shutDown();
            }
            this.addedStatements = null;
        }
        if (this.removedStatements != null) {
            this.removedStatements.shutDown();
            this.removedStatements = null;
        }
        this.addedStatementsSet.clear();
        this.removedStatementsSet.clear();
        this.stats = null;
        this.preparedHasRun = false;
        this.isShapeRefreshNeeded = false;
        this.selectNodeCache = null;
        this.shapesModifiedInCurrentTransaction = false;
        this.stamp = 0L;
        this.currentIsolationLevel = null;
        if (this.sail.isPerformanceLogging()) {
            logger.info("cleanup() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private List<NodeShape> refreshShapes() {
        if (this.isShapeRefreshNeeded) {
            this.nodeShapes = this.sail.refreshShapes(this.shapesRepoConnection);
            this.isShapeRefreshNeeded = false;
            this.shapesModifiedInCurrentTransaction = true;
        }
        return this.nodeShapes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tuple> validate(List<NodeShape> nodeShapes, boolean validateEntireBaseSail) {
        if (!this.sail.isValidationEnabled()) {
            return Collections.emptyList();
        }
        if (this.sail.isRdfsSubClassReasoning()) {
            this.rdfsSubClassOfReasoner = RdfsSubClassOfReasoner.createReasoner(this);
        }
        try {
            List<Tuple> list;
            block11: {
                this.validating = true;
                this.fillAddedAndRemovedStatementRepositories();
                long beforeValidation = 0L;
                if (this.sail.isPerformanceLogging()) {
                    beforeValidation = System.currentTimeMillis();
                }
                try {
                    Stream planNodeStream = nodeShapes.stream().flatMap(nodeShape -> nodeShape.generatePlans(this, (NodeShape)nodeShape, this.sail.isLogValidationPlans(), validateEntireBaseSail));
                    if (this.sail.isParallelValidation()) {
                        planNodeStream = (Stream)planNodeStream.parallel();
                    }
                    list = planNodeStream.filter(Objects::nonNull).flatMap(planNode -> {
                        try (Stream<Tuple> stream = Iterations.stream(planNode.iterator());){
                            boolean valid;
                            if (LoggingNode.loggingEnabled) {
                                PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                                logger.info("Start execution of plan " + propertyShape.getNodeShape().toString() + " : " + propertyShape.getId());
                            }
                            long before = 0L;
                            if (this.sail.isPerformanceLogging()) {
                                before = System.currentTimeMillis();
                            }
                            List collect = stream.collect(Collectors.toList());
                            if (this.sail.isPerformanceLogging()) {
                                long after = System.currentTimeMillis();
                                PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                                logger.info("Execution of plan took {} ms for {} : {}", new Object[]{after - before, propertyShape.getNodeShape().toString(), propertyShape.toString()});
                            }
                            if (LoggingNode.loggingEnabled) {
                                PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                                logger.info("Finished execution of plan {} : {}", (Object)propertyShape.getNodeShape().toString(), (Object)propertyShape.getId());
                            }
                            boolean bl = valid = collect.size() == 0;
                            if (!valid && this.sail.isLogValidationViolations()) {
                                PropertyShape propertyShape = ((EnrichWithShape)planNode).getPropertyShape();
                                logger.info("SHACL not valid. The following experimental debug results were produced: \n\tNodeShape: {}\n\tPropertyShape: {} \n\t\t{}", new Object[]{propertyShape.getNodeShape().getId(), propertyShape.getId(), collect.stream().map(a -> a.toString() + " -cause-> " + a.getCause()).collect(Collectors.joining("\n\t\t"))});
                            }
                            Stream stream2 = collect.stream();
                            return stream2;
                        }
                    }).collect(Collectors.toList());
                    this.connectionsToClose.forEach(SailConnection::close);
                    this.connectionsToClose = new ConcurrentLinkedQueue();
                    if (!this.sail.isPerformanceLogging()) break block11;
                }
                catch (Throwable throwable) {
                    this.connectionsToClose.forEach(SailConnection::close);
                    this.connectionsToClose = new ConcurrentLinkedQueue();
                    if (this.sail.isPerformanceLogging()) {
                        logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
                    }
                    throw throwable;
                }
                logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
            }
            return list;
        }
        finally {
            this.validating = false;
            this.rdfsSubClassOfReasoner = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void fillAddedAndRemovedStatementRepositories() {
        long before;
        block28: {
            block29: {
                before = 0L;
                if (this.sail.isPerformanceLogging()) {
                    before = System.currentTimeMillis();
                }
                this.connectionsToClose.forEach(SailConnection::close);
                this.connectionsToClose = new ConcurrentLinkedQueue();
                if (!this.stats.baseSailEmpty) break block29;
                this.flush();
                if ((this.rdfsSubClassOfReasoner == null || this.rdfsSubClassOfReasoner.isEmpty()) && this.sail.getBaseSail() instanceof MemoryStore && this.getIsolationLevel() == IsolationLevels.NONE) {
                    this.addedStatements = (MemoryStore)this.sail.getBaseSail();
                    this.removedStatements = this.getNewMemorySail();
                    break block28;
                } else {
                    this.addedStatements = this.getNewMemorySail();
                    this.removedStatements = this.getNewMemorySail();
                    try (Stream<? extends Statement> stream = Iterations.stream(this.getStatements(null, null, null, false, new Resource[0]));
                         NotifyingSailConnection connection = this.addedStatements.getConnection();){
                        connection.begin(IsolationLevels.NONE);
                        stream.flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                        connection.commit();
                        break block28;
                    }
                }
            }
            ((Stream)Stream.of(this.addedStatementsSet, this.removedStatementsSet).parallel()).forEach(set -> {
                MemoryStore repository;
                HashSet<Statement> otherSet;
                if (set == this.addedStatementsSet) {
                    otherSet = this.removedStatementsSet;
                    if (this.addedStatements != null && this.addedStatements != this.sail.getBaseSail()) {
                        this.addedStatements.shutDown();
                    }
                    repository = this.addedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::added);
                } else {
                    otherSet = this.addedStatementsSet;
                    if (this.removedStatements != null) {
                        this.removedStatements.shutDown();
                        this.removedStatements = null;
                    }
                    repository = this.removedStatements = this.getNewMemorySail();
                    set.forEach(this.stats::removed);
                }
                try (NotifyingSailConnection connection = repository.getConnection();){
                    connection.begin(IsolationLevels.NONE);
                    set.stream().filter(statement -> !otherSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext()));
                    connection.commit();
                }
            });
        }
        this.selectNodeCache = new HashMap<PlanNode, BufferedSplitter>();
        if (this.sail.isPerformanceLogging()) {
            logger.info("fillAddedAndRemovedStatementRepositories() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private IsolationLevel getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    @Override
    public synchronized void close() throws SailException {
        if (this.isActive()) {
            this.rollback();
        }
        this.shapesRepoConnection.close();
        this.previousStateConnection.close();
        super.close();
        this.connectionsToClose.forEach(SailConnection::close);
        this.connectionsToClose = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws SailException {
        long readStamp = 0L;
        try {
            long before = 0L;
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            if (!this.sail.holdsWriteLock(this.stamp)) {
                readStamp = this.sail.readlock();
            }
            this.loadCachedNodeShapes();
            List<NodeShape> nodeShapesBeforeRefresh = this.nodeShapes;
            this.refreshShapes();
            List<NodeShape> nodeShapesAfterRefresh = this.nodeShapes;
            if (this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() && !this.shapesModifiedInCurrentTransaction) {
                boolean currentBaseSailEmpty;
                boolean bl = currentBaseSailEmpty = !this.hasStatement(null, null, null, false, new Resource[0]);
                if (!this.stats.baseSailEmpty || currentBaseSailEmpty) {
                    logger.debug("Nothing has changed, nothing to validate.");
                    return;
                }
            }
            if (this.shapesModifiedInCurrentTransaction && this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty()) {
                assert (nodeShapesBeforeRefresh != nodeShapesAfterRefresh);
                HashSet<NodeShape> nodeShapesBeforeRefreshSet = new HashSet<NodeShape>(nodeShapesBeforeRefresh);
                nodeShapesAfterRefresh = nodeShapesAfterRefresh.stream().filter(nodeShape -> !nodeShapesBeforeRefreshSet.contains(nodeShape)).collect(Collectors.toList());
            }
            List<Tuple> invalidTuples = this.validate(nodeShapesAfterRefresh, this.shapesModifiedInCurrentTransaction);
            boolean valid = invalidTuples.isEmpty();
            if (this.sail.isPerformanceLogging()) {
                logger.info("prepare() including validation excluding locking and super.prepare() took {} ms", (Object)(System.currentTimeMillis() - before));
            }
            if (!valid) {
                throw new ShaclSailValidationException(invalidTuples);
            }
        }
        finally {
            this.preparedHasRun = true;
            if (readStamp != 0L && !this.sail.holdsWriteLock(this.stamp)) {
                this.sail.releaseReadlock(readStamp);
            }
            super.prepare();
            this.previousStateConnection.prepare();
        }
    }

    private void loadCachedNodeShapes() {
        this.nodeShapes = this.sail.getNodeShapes();
    }

    @Override
    public void statementAdded(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.addedStatementsSet.add(statement);
        if (!add) {
            this.removedStatementsSet.remove(statement);
        }
    }

    @Override
    public void statementRemoved(Statement statement) {
        if (this.preparedHasRun) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        boolean add = this.removedStatementsSet.add(statement);
        if (!add) {
            this.addedStatementsSet.remove(statement);
        }
    }

    public synchronized PlanNode getCachedNodeFor(PlanNode select) {
        if (!this.sail.isCacheSelectNodes()) {
            return select;
        }
        BufferedSplitter bufferedSplitter = this.selectNodeCache.computeIfAbsent(select, BufferedSplitter::new);
        return bufferedSplitter.getPlanNode();
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    @Override
    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, final Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Set<Resource> inferredTypes;
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            return this.getCloseableIteration(this.shapesRepoConnection.getStatements(subj, pred, obj, includeInferred, new Resource[0]));
        }
        if (this.rdfsSubClassOfReasoner != null && includeInferred && this.validating && obj instanceof Resource && RDF.TYPE.equals(pred) && !(inferredTypes = this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj)).isEmpty()) {
            final CloseableIteration[] statementsMatchingInferredTypes = (CloseableIteration[])inferredTypes.stream().map(r -> super.getStatements(subj, pred, (Value)r, false, contexts)).toArray(CloseableIteration[]::new);
            return new CloseableIteration<Statement, SailException>(){
                UnionIteration<Statement, SailException> unionIteration;
                Statement next;
                HashSet<Statement> dedupe;
                {
                    this.unionIteration = new UnionIteration(statementsMatchingInferredTypes);
                    this.next = null;
                    this.dedupe = new HashSet();
                }

                private void calculateNext() {
                    if (this.next != null) {
                        return;
                    }
                    while (this.next == null && this.unionIteration.hasNext()) {
                        Statement temp = (Statement)this.unionIteration.next();
                        temp = SimpleValueFactory.getInstance().createStatement(temp.getSubject(), temp.getPredicate(), obj, temp.getContext());
                        if (!this.dedupe.isEmpty()) {
                            boolean contains = this.dedupe.contains(temp);
                            if (contains) continue;
                            this.next = temp;
                            this.dedupe.add(this.next);
                            continue;
                        }
                        this.next = temp;
                        this.dedupe.add(this.next);
                    }
                }

                @Override
                public boolean hasNext() throws SailException {
                    this.calculateNext();
                    return this.next != null;
                }

                @Override
                public Statement next() throws SailException {
                    this.calculateNext();
                    Statement temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() throws SailException {
                    this.unionIteration.remove();
                }

                @Override
                public void close() throws SailException {
                    this.unionIteration.close();
                }
            };
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    private CloseableIteration<Statement, SailException> getCloseableIteration(final RepositoryResult<Statement> statements1) {
        return new CloseableIteration<Statement, SailException>(){
            RepositoryResult<Statement> statements;
            {
                this.statements = statements1;
            }

            @Override
            public boolean hasNext() throws SailException {
                return this.statements.hasNext();
            }

            @Override
            public Statement next() throws SailException {
                return this.statements.next();
            }

            @Override
            public void remove() throws SailException {
                this.statements.remove();
            }

            @Override
            public void close() throws SailException {
                this.statements.close();
            }
        };
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (contexts.length == 1 && contexts[0].equals(RDF4J.SHACL_SHAPE_GRAPH)) {
            return this.shapesRepoConnection.hasStatement(subj, pred, obj, includeInferred, new Resource[0]);
        }
        boolean hasStatement = super.hasStatement(subj, pred, obj, includeInferred, contexts);
        if (this.rdfsSubClassOfReasoner != null && includeInferred && this.validating && obj instanceof Resource && RDF.TYPE.equals(pred)) {
            return hasStatement | this.rdfsSubClassOfReasoner.backwardsChain((Resource)obj).stream().map(type -> super.hasStatement(subj, pred, (Value)type, false, contexts)).reduce((a, b) -> a != false || b != false).orElse(false);
        }
        return hasStatement;
    }

    public ValidationReport revalidate() {
        if (!this.isActive()) {
            throw new IllegalStateException("No active transaction!");
        }
        this.loadCachedNodeShapes();
        List<Tuple> validate = this.validate(this.nodeShapes, true);
        return new ShaclSailValidationException(validate).getValidationReport();
    }

    public class Stats {
        boolean baseSailEmpty;
        boolean hasAdded;
        boolean hasRemoved;

        public void added(Statement statement) {
            this.hasAdded = true;
        }

        public void removed(Statement statement) {
            this.hasRemoved = true;
        }

        public boolean hasAdded() {
            return this.hasAdded;
        }

        public boolean hasRemoved() {
            return this.hasRemoved;
        }

        public boolean isBaseSailEmpty() {
            return this.baseSailEmpty;
        }
    }
}

