/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class BufferedPlanNode<T extends MultiStreamPlanNode & PlanNode>
implements PushablePlanNode {
    private T parent;
    private Queue<Tuple> buffer = new ArrayDeque<Tuple>();
    private boolean closed;
    private boolean printed;

    BufferedPlanNode(T parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            {
                BufferedPlanNode.this.parent.init();
            }

            @Override
            public void close() throws SailException {
                BufferedPlanNode.this.closed = true;
                BufferedPlanNode.this.parent.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !BufferedPlanNode.this.buffer.isEmpty();
            }

            private void calculateNext() {
                boolean success;
                while (BufferedPlanNode.this.buffer.isEmpty() && (success = BufferedPlanNode.this.parent.incrementIterator())) {
                }
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                return (Tuple)BufferedPlanNode.this.buffer.remove();
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return ((PlanNode)this.parent).depth();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        ((PlanNode)this.parent).getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return ((PlanNode)this.parent).getIteratorDataType();
    }

    @Override
    public void push(Tuple next) {
        this.buffer.add(next);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "BufferedPlanNode";
    }
}

