/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class BulkedExternalInnerJoin
extends AbstractBulkJoinPlanNode {
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final ParsedQuery parsedQuery;
    private final boolean skipBasedOnPreviousConnection;
    private boolean printed = false;

    public BulkedExternalInnerJoin(PlanNode leftNode, SailConnection connection, String query, boolean skipBasedOnPreviousConnection) {
        this.leftNode = leftNode;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        this.parsedQuery = queryParserFactory.getParser().parseQuery("select * where { VALUES (?a) {}" + query + "} order by ?a", null);
        this.connection = connection;
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            ArrayDeque<Tuple> left = new ArrayDeque();
            ArrayDeque<Tuple> right = new ArrayDeque();
            ArrayDeque<Tuple> joined = new ArrayDeque();
            CloseableIteration<Tuple, SailException> leftNodeIterator = BulkedExternalInnerJoin.access$000(BulkedExternalInnerJoin.this).iterator();

            private void calculateNext() {
                if (!this.joined.isEmpty()) {
                    return;
                }
                while (this.joined.isEmpty() && this.leftNodeIterator.hasNext()) {
                    while (this.left.size() < 200 && this.leftNodeIterator.hasNext()) {
                        this.left.addFirst((Tuple)this.leftNodeIterator.next());
                    }
                    AbstractBulkJoinPlanNode.runQuery(this.left, this.right, BulkedExternalInnerJoin.this.connection, BulkedExternalInnerJoin.this.parsedQuery, BulkedExternalInnerJoin.this.skipBasedOnPreviousConnection);
                    while (!this.right.isEmpty()) {
                        Tuple leftPeek = this.left.peekLast();
                        Tuple rightPeek = this.right.peekLast();
                        if (rightPeek.line.get(0) == leftPeek.line.get(0) || rightPeek.line.get(0).equals(leftPeek.line.get(0))) {
                            this.joined.addLast(TupleHelper.join(leftPeek, rightPeek));
                            this.right.removeLast();
                            Tuple rightPeek2 = this.right.peekLast();
                            if (rightPeek2 != null && rightPeek2.line.get(0).equals(leftPeek.line.get(0))) continue;
                            this.left.removeLast();
                            continue;
                        }
                        int compare = rightPeek.line.get(0).stringValue().compareTo(leftPeek.line.get(0).stringValue());
                        if (compare < 0) {
                            if (this.right.isEmpty()) {
                                throw new IllegalStateException();
                            }
                            this.right.removeLast();
                            continue;
                        }
                        if (this.left.isEmpty()) {
                            throw new IllegalStateException();
                        }
                        this.left.removeLast();
                    }
                    this.left.clear();
                }
            }

            @Override
            public void close() throws SailException {
                this.leftNodeIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return !this.joined.isEmpty();
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                return this.joined.removeFirst();
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        }
        if (this.skipBasedOnPreviousConnection && this.connection instanceof ShaclSailConnection) {
            NotifyingSailConnection previousStateConnection = ((ShaclSailConnection)this.connection).getPreviousStateConnection();
            stringBuilder.append(System.identityHashCode(previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "BulkedExternalInnerJoin{parsedQuery=" + this.parsedQuery.getSourceString() + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.leftNode.getIteratorDataType();
    }

    static /* synthetic */ PlanNode access$000(BulkedExternalInnerJoin x0) {
        return x0.leftNode;
    }
}

