/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class LeftOuterJoin
implements PlanNode {
    private PlanNode left;
    private PlanNode right;
    private boolean printed = false;

    public LeftOuterJoin(PlanNode left, PlanNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> leftIterator;
            CloseableIteration<Tuple, SailException> rightIterator;
            Tuple next;
            Tuple nextLeft;
            Tuple nextRight;
            Tuple prevLeft;
            {
                this.leftIterator = LeftOuterJoin.this.left.iterator();
                this.rightIterator = LeftOuterJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (Tuple)this.leftIterator.next();
                }
                if (this.nextLeft == null) {
                    return;
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (Tuple)this.rightIterator.next();
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.line.get(0) == this.nextRight.line.get(0) || this.nextLeft.line.get(0).equals(this.nextRight.line.get(0))) {
                            this.next = TupleHelper.join(this.nextLeft, this.nextRight);
                            this.prevLeft = this.nextLeft;
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTo(this.nextRight);
                        if (compareTo < 0) {
                            if (this.prevLeft != this.nextLeft) {
                                this.prevLeft = this.nextLeft;
                                this.next = this.nextLeft;
                                continue;
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (Tuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (Tuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    if (this.prevLeft == this.nextLeft) {
                        if (!this.leftIterator.hasNext()) break;
                        this.nextLeft = (Tuple)this.leftIterator.next();
                        continue;
                    }
                    this.prevLeft = this.nextLeft;
                    this.next = this.nextLeft;
                }
            }

            @Override
            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        if (this.left.getIteratorDataType() == this.right.getIteratorDataType()) {
            return this.left.getIteratorDataType();
        }
        throw new IllegalStateException("Not implemented support for when left and right have different types of data");
    }

    public String toString() {
        return "LeftOuterJoin";
    }
}

