/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class NonUniqueTargetLang
implements PlanNode {
    PlanNode parent;
    private boolean printed = false;
    private Set<String> seenLanguages = new HashSet<String>();

    public NonUniqueTargetLang(PlanNode parent) {
        this.parent = parent;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            Tuple next;
            Tuple previous;
            {
                this.parentIterator = NonUniqueTargetLang.this.parent.iterator();
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                while (this.next == null && this.parentIterator.hasNext()) {
                    this.next = (Tuple)this.parentIterator.next();
                    if (this.previous != null && !this.previous.line.get(0).equals(this.next.line.get(0))) {
                        NonUniqueTargetLang.this.seenLanguages = new HashSet();
                    }
                    this.previous = this.next;
                    Value value = this.next.getlist().get(1);
                    if (value instanceof Literal) {
                        Optional<String> lang = ((Literal)value).getLanguage();
                        if (!lang.isPresent()) {
                            this.next = null;
                            continue;
                        }
                        if (NonUniqueTargetLang.this.seenLanguages.contains(lang.get())) continue;
                        NonUniqueTargetLang.this.seenLanguages.add(lang.get());
                        this.next = null;
                        continue;
                    }
                    this.next = null;
                }
            }

            @Override
            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "NonUniqueTargetLang";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }
}

