/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Day
implements Function {
    @Override
    public String getURI() {
        return FN.DAY_FROM_DATETIME.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("DAY requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            IRI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isCalendarDatatype(datatype)) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int day = calValue.getDay();
                    if (Integer.MIN_VALUE != day) {
                        return valueFactory.createLiteral(String.valueOf(day), XMLSchema.INTEGER);
                    }
                    throw new ValueExprEvaluationException("can not determine day from value: " + argValue);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

