/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.io.File;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.base.AbstractRepository;

public class ProxyRepository
extends AbstractRepository
implements RepositoryResolverClient {
    private File dataDir;
    private volatile Repository proxiedRepository;
    private String proxiedID;
    private volatile RepositoryResolver resolver;

    public ProxyRepository() {
    }

    public ProxyRepository(String proxiedIdentity) {
        this.setProxiedIdentity(proxiedIdentity);
    }

    public ProxyRepository(RepositoryResolver resolver, String proxiedIdentity) {
        this.setRepositoryResolver(resolver);
        this.setProxiedIdentity(proxiedIdentity);
    }

    public final void setProxiedIdentity(String value) {
        if (!value.equals(this.proxiedID)) {
            this.proxiedID = value;
            this.proxiedRepository = null;
        }
    }

    public String getProxiedIdentity() {
        return this.proxiedID;
    }

    @Override
    public final void setRepositoryResolver(RepositoryResolver resolver) {
        if (resolver != this.resolver) {
            this.resolver = resolver;
            this.proxiedRepository = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository getProxiedRepository() {
        Repository result = this.proxiedRepository;
        if (result == null) {
            ProxyRepository proxyRepository = this;
            synchronized (proxyRepository) {
                result = this.proxiedRepository;
                if (result == null) {
                    assert (null != this.resolver) : "Expected resolver to be set.";
                    assert (null != this.proxiedID) : "Expected proxiedID to be set.";
                    try {
                        result = this.proxiedRepository = this.resolver.getRepository(this.proxiedID);
                    }
                    catch (RDF4JException ore) {
                        throw new IllegalStateException(ore);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        return this.getProxiedRepository().isWritable();
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        return this.getProxiedRepository().getConnection();
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.getProxiedRepository().getValueFactory();
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
        if (this.resolver == null) {
            throw new RepositoryException("Expected RepositoryResolver to be set.");
        }
        this.getProxiedRepository().initialize();
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
        this.getProxiedRepository().shutDown();
    }
}

