/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockManager;
import org.eclipse.rdf4j.common.io.MavenUtil;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.base.SnapshotSailStore;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSail;
import org.eclipse.rdf4j.sail.helpers.DirectoryLockManager;
import org.eclipse.rdf4j.sail.nativerdf.MemoryOverflowModel;
import org.eclipse.rdf4j.sail.nativerdf.NativeSailStore;
import org.eclipse.rdf4j.sail.nativerdf.NativeStoreConnection;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeStore
extends AbstractNotifyingSail
implements FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(NativeStore.class);
    private static final String VERSION = MavenUtil.loadVersion("org.eclipse.rdf4j", "rdf4j-sail-nativerdf", "devel");
    private volatile String tripleIndexes;
    private volatile boolean forceSync = false;
    private volatile int valueCacheSize = 512;
    private volatile int valueIDCacheSize = 128;
    private volatile int namespaceCacheSize = 64;
    private volatile int namespaceIDCacheSize = 32;
    private SailStore store;
    private volatile Lock dirLock;
    private EvaluationStrategyFactory evalStratFactory;
    private FederatedServiceResolver serviceResolver;
    private SPARQLServiceResolver dependentServiceResolver;
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private final LockManager isolatedLockManager = new LockManager(NativeStore.debugEnabled());
    private final LockManager disabledIsolationLockManager = new LockManager(NativeStore.debugEnabled());

    public NativeStore() {
        this.setSupportedIsolationLevels(IsolationLevels.NONE, IsolationLevels.READ_COMMITTED, IsolationLevels.SNAPSHOT_READ, IsolationLevels.SNAPSHOT, IsolationLevels.SERIALIZABLE);
        this.setDefaultIsolationLevel(IsolationLevels.SNAPSHOT_READ);
    }

    public NativeStore(File dataDir) {
        this();
        this.setDataDir(dataDir);
    }

    public NativeStore(File dataDir, String tripleIndexes) {
        this(dataDir);
        this.setTripleIndexes(tripleIndexes);
    }

    public void setTripleIndexes(String tripleIndexes) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.tripleIndexes = tripleIndexes;
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    public synchronized EvaluationStrategyFactory getEvaluationStrategyFactory() {
        if (this.evalStratFactory == null) {
            this.evalStratFactory = new StrictEvaluationStrategyFactory(this.getFederatedServiceResolver());
        }
        this.evalStratFactory.setQuerySolutionCacheThreshold(this.getIterationCacheSyncThreshold());
        return this.evalStratFactory;
    }

    public synchronized void setEvaluationStrategyFactory(EvaluationStrategyFactory factory) {
        this.evalStratFactory = factory;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new SPARQLServiceResolver();
            }
            this.setFederatedServiceResolver(this.dependentServiceResolver);
        }
        return this.serviceResolver;
    }

    @Override
    public synchronized void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        if (resolver != null && this.evalStratFactory instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)this.evalStratFactory)).setFederatedServiceResolver(resolver);
        }
    }

    @Override
    protected void initializeInternal() throws SailException {
        logger.debug("Initializing NativeStore...");
        File dataDir = this.getDataDir();
        if (dataDir == null) {
            throw new SailException("Data dir has not been set");
        }
        if (!dataDir.exists()) {
            boolean success = dataDir.mkdirs();
            if (!success) {
                throw new SailException("Unable to create data directory: " + dataDir);
            }
        } else {
            if (!dataDir.isDirectory()) {
                throw new SailException("The specified path does not denote a directory: " + dataDir);
            }
            if (!dataDir.canRead()) {
                throw new SailException("Not allowed to read from the specified directory: " + dataDir);
            }
        }
        this.dirLock = new DirectoryLockManager(dataDir).lockOrFail();
        logger.debug("Data dir is " + dataDir);
        try {
            String version;
            File versionFile = new File(dataDir, "nativerdf.ver");
            String string = version = versionFile.exists() ? FileUtils.readFileToString((File)versionFile) : null;
            if (!VERSION.equals(version) && this.upgradeStore(dataDir, version)) {
                FileUtils.writeStringToFile((File)versionFile, (String)VERSION);
            }
            final NativeSailStore master = new NativeSailStore(dataDir, this.tripleIndexes, this.forceSync, this.valueCacheSize, this.valueIDCacheSize, this.namespaceCacheSize, this.namespaceIDCacheSize);
            this.store = new SnapshotSailStore(master, () -> new MemoryOverflowModel(){

                @Override
                protected SailStore createSailStore(File dataDir) throws IOException, SailException {
                    return new NativeSailStore(dataDir, NativeStore.this.getTripleIndexes());
                }
            }){

                @Override
                public SailSource getExplicitSailSource() {
                    if (NativeStore.this.isIsolationDisabled()) {
                        return master.getExplicitSailSource();
                    }
                    return super.getExplicitSailSource();
                }

                @Override
                public SailSource getInferredSailSource() {
                    if (NativeStore.this.isIsolationDisabled()) {
                        return master.getInferredSailSource();
                    }
                    return super.getInferredSailSource();
                }
            };
        }
        catch (Throwable e) {
            this.dirLock.release();
            throw new SailException(e);
        }
        logger.debug("NativeStore initialized");
    }

    @Override
    protected void shutDownInternal() throws SailException {
        logger.debug("Shutting down NativeStore...");
        try {
            this.store.close();
            logger.debug("NativeStore shut down");
        }
        finally {
            this.dirLock.release();
            if (this.dependentServiceResolver != null) {
                this.dependentServiceResolver.shutDown();
            }
            logger.debug("NativeStore shut down");
        }
    }

    @Override
    public boolean isWritable() {
        return this.getDataDir().canWrite();
    }

    @Override
    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        try {
            return new NativeStoreConnection(this);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.store.getValueFactory();
    }

    protected Lock getTransactionLock(IsolationLevel level) throws SailException {
        this.txnLockManager.lock();
        try {
            if (IsolationLevels.NONE.isCompatibleWith(level)) {
                this.isolatedLockManager.waitForActiveLocks();
                Lock lock = this.disabledIsolationLockManager.createLock(level.toString());
                return lock;
            }
            this.disabledIsolationLockManager.waitForActiveLocks();
            Lock lock = this.isolatedLockManager.createLock(level.toString());
            return lock;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException(e);
        }
        finally {
            this.txnLockManager.unlock();
        }
    }

    boolean isIsolationDisabled() {
        return this.disabledIsolationLockManager.isActiveLock();
    }

    SailStore getSailStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeStore(File dataDir, String version) throws IOException, SailException {
        if (version == null) {
            try (ValueStore valueStore = new ValueStore(dataDir);){
                valueStore.checkConsistency();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

