/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

abstract class AbstractBulkJoinPlanNode
implements PlanNode {
    protected String[] variables;
    ValidationExecutionLogger validationExecutionLogger;

    AbstractBulkJoinPlanNode() {
    }

    void runQuery(ArrayDeque<Tuple> left, ArrayDeque<Tuple> right, SailConnection connection, ParsedQuery parsedQuery, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, String[] variables) {
        List<BindingSet> newBindindingset = this.buildBindingSets(left, connection, skipBasedOnPreviousConnection, previousStateConnection);
        if (!newBindindingset.isEmpty()) {
            this.updateQuery(parsedQuery, newBindindingset);
            AbstractBulkJoinPlanNode.executeQuery(right, connection, parsedQuery, variables);
        }
    }

    private static void executeQuery(ArrayDeque<Tuple> right, SailConnection connection, ParsedQuery parsedQuery, String[] variables) {
        try (Stream stream = connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), new MapBindingSet(), true).stream();){
            stream.map(t -> new Tuple((BindingSet)t, variables)).forEachOrdered(right::addFirst);
        }
    }

    private void updateQuery(ParsedQuery parsedQuery, final List<BindingSet> newBindindingset) {
        try {
            parsedQuery.getTupleExpr().visitChildren(new AbstractQueryModelVisitor<Exception>(){

                @Override
                public void meet(BindingSetAssignment node) {
                    node.setBindingSets(newBindindingset);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<BindingSet> buildBindingSets(ArrayDeque<Tuple> left, SailConnection connection, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection) {
        return left.stream().filter(tuple -> {
            if (!skipBasedOnPreviousConnection) {
                return true;
            }
            boolean hasStatement = previousStateConnection.hasStatement((Resource)tuple.line.get(0), null, null, true, new Resource[0]);
            if (!hasStatement && GlobalValidationExecutionLogging.loggingEnabled) {
                this.validationExecutionLogger.log(this.depth(), this.getClass().getSimpleName() + ":IgnoredDueToPreviousStateConnection", (Tuple)tuple, this, this.getId());
            }
            return hasStatement;
        }).map(tuple -> (Resource)tuple.line.get(0)).map(r -> new ListBindingSet(Collections.singletonList("a"), Collections.singletonList(r))).collect(Collectors.toList());
    }
}

