/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContext;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContextInitializer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.TupleFunctionEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.QueryContextIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailConnectionQueryPreparer;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.SailTripleSource;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.AbstractForwardChainingInferencerConnection;
import org.eclipse.rdf4j.sail.inferencer.util.RDFInferencerInserter;
import org.eclipse.rdf4j.sail.spin.ConstraintViolationException;
import org.eclipse.rdf4j.sail.spin.SpinFunctionInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinInferencing;
import org.eclipse.rdf4j.sail.spin.SpinMagicPropertyInterpreter;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.eclipse.rdf4j.spin.ConstraintViolation;
import org.eclipse.rdf4j.spin.RuleProperty;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.TransientFunction;
import org.eclipse.rdf4j.spin.function.TransientTupleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class SpinSailConnection
extends AbstractForwardChainingInferencerConnection {
    private static final Logger logger = LoggerFactory.getLogger(SpinSailConnection.class);
    private static final IRI EXECUTED = SimpleValueFactory.getInstance().createIRI("http://www.openrdf.org/schema/spin#executed");
    private static final Marker constraintViolationMarker = MarkerFactory.getMarker((String)"ConstraintViolation");
    private static final String CONSTRAINT_VIOLATION_MESSAGE = "Constraint violation: {}: {} {} {}";
    private final TupleFunctionEvaluationMode evaluationMode;
    private final boolean axiomClosureNeeded;
    private final FunctionRegistry functionRegistry;
    private final TupleFunctionRegistry tupleFunctionRegistry;
    private final FederatedServiceResolver serviceResolver;
    private final AbstractFederatedServiceResolver tupleFunctionServiceResolver;
    private final ValueFactory vf;
    private final TripleSource tripleSource;
    private final List<QueryContextInitializer> queryContextInitializers;
    private final SpinParser parser;
    private List<IRI> orderedRuleProperties;
    private Map<IRI, RuleProperty> rulePropertyMap;
    private Map<Resource, Executions> ruleExecutions;
    private Map<IRI, Set<IRI>> classToSuperclassMap;
    private SailConnectionQueryPreparer queryPreparer;
    private SpinSail sail;
    private static final List<Statement> schemaSp;
    private static final List<Statement> schemaSpin;
    private static final List<Statement> schemaSplSpin;
    private static final List<Statement> schemaSpinFull;
    private static final List<Statement> schemaSpinFullFC;

    public SpinSailConnection(SpinSail sail, InferencerConnection con) {
        super(sail, con);
        this.sail = sail;
        this.evaluationMode = sail.getEvaluationMode();
        this.axiomClosureNeeded = sail.isAxiomClosureNeeded();
        this.functionRegistry = sail.getFunctionRegistry();
        this.tupleFunctionRegistry = sail.getTupleFunctionRegistry();
        this.vf = sail.getValueFactory();
        this.queryContextInitializers = sail.getQueryContextInitializers();
        this.parser = sail.getSpinParser();
        this.tripleSource = new SailTripleSource(this.getWrappedConnection(), true, this.vf);
        this.queryPreparer = new SailConnectionQueryPreparer((SailConnection)this, true, this.tripleSource);
        this.serviceResolver = sail.getFederatedServiceResolver();
        if (this.evaluationMode == TupleFunctionEvaluationMode.SERVICE) {
            if (!(this.serviceResolver instanceof AbstractFederatedServiceResolver)) {
                throw new IllegalArgumentException("SERVICE EvaluationMode requires a FederatedServiceResolver that is an instance of " + AbstractFederatedServiceResolver.class.getName());
            }
            this.tupleFunctionServiceResolver = (AbstractFederatedServiceResolver)this.serviceResolver;
        } else {
            this.tupleFunctionServiceResolver = null;
        }
        con.addConnectionListener(new SubclassListener());
        con.addConnectionListener(new RulePropertyListener());
        con.addConnectionListener(new InvalidationListener());
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.queryPreparer.setParserConfig(parserConfig);
    }

    public ParserConfig getParserConfig() {
        return this.queryPreparer.getParserConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter;
        QueryContext qctx = new QueryContext(this.queryPreparer);
        qctx.begin();
        try {
            this.initQueryContext(qctx);
            iter = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
        }
        finally {
            try {
                this.destroyQueryContext(qctx);
            }
            finally {
                qctx.end();
            }
        }
        return new QueryContextIteration(iter, qctx);
    }

    private void initQueryContext(QueryContext qctx) {
        for (QueryContextInitializer initializer : this.queryContextInitializers) {
            initializer.init(qctx);
        }
    }

    private void destroyQueryContext(QueryContext qctx) {
        for (QueryContextInitializer initializer : this.queryContextInitializers) {
            initializer.destroy(qctx);
        }
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        new SpinFunctionInterpreter(this.parser, this.tripleSource, this.functionRegistry).optimize(tupleExpr, dataset, bindings);
        new SpinMagicPropertyInterpreter(this.parser, this.tripleSource, this.tupleFunctionRegistry, this.tupleFunctionServiceResolver).optimize(tupleExpr, dataset, bindings);
        logger.trace("SPIN query model:\n{}", (Object)tupleExpr);
        if (this.evaluationMode == TupleFunctionEvaluationMode.TRIPLE_SOURCE) {
            TupleFunctionEvaluationStrategy strategy = new TupleFunctionEvaluationStrategy((TripleSource)new SailTripleSource(this, includeInferred, this.vf), dataset, this.serviceResolver, this.tupleFunctionRegistry);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(new TupleFunctionEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            try {
                return strategy.evaluate(tupleExpr, bindings);
            }
            catch (QueryEvaluationException e) {
                throw new SailException(e);
            }
        }
        return super.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    @Override
    public void close() throws SailException {
        super.close();
    }

    private void initRuleProperties() throws RDF4JException {
        if (this.rulePropertyMap != null) {
            return;
        }
        this.rulePropertyMap = this.parser.parseRuleProperties(this.tripleSource);
        HashSet<IRI> remainingRules = new HashSet<IRI>(this.rulePropertyMap.keySet());
        ArrayList<IRI> reverseOrder = new ArrayList<IRI>(remainingRules.size());
        while (!remainingRules.isEmpty()) {
            Iterator ruleIter = remainingRules.iterator();
            while (ruleIter.hasNext()) {
                IRI rule = (IRI)ruleIter.next();
                boolean isTerminal = true;
                RuleProperty ruleProperty = this.rulePropertyMap.get(rule);
                if (ruleProperty != null) {
                    List<IRI> nextRules = ruleProperty.getNextRules();
                    for (IRI nextRule : nextRules) {
                        if (nextRule.equals(rule) || !remainingRules.contains(nextRule)) continue;
                        isTerminal = false;
                        break;
                    }
                }
                if (!isTerminal) continue;
                reverseOrder.add(rule);
                ruleIter.remove();
            }
        }
        this.orderedRuleProperties = Lists.reverse(reverseOrder);
    }

    private void resetRuleProperties() {
        this.orderedRuleProperties = null;
        this.rulePropertyMap = null;
    }

    private List<IRI> getRuleProperties() throws RDF4JException {
        this.initRuleProperties();
        return this.orderedRuleProperties;
    }

    private RuleProperty getRuleProperty(IRI ruleProp) throws RDF4JException {
        this.initRuleProperties();
        return this.rulePropertyMap.get(ruleProp);
    }

    private void initClasses() throws RDF4JException {
        if (this.classToSuperclassMap != null) {
            return;
        }
        this.classToSuperclassMap = new HashMap<IRI, Set<IRI>>();
        try (CloseableIteration<? extends Statement, QueryEvaluationException> stmtIter = this.tripleSource.getStatements(null, RDFS.SUBCLASSOF, null, new Resource[0]);){
            while (stmtIter.hasNext()) {
                Statement stmt = (Statement)stmtIter.next();
                if (!(stmt.getSubject() instanceof IRI) || !(stmt.getObject() instanceof IRI)) continue;
                IRI cls = (IRI)stmt.getSubject();
                IRI superclass = (IRI)stmt.getObject();
                Set<IRI> superclasses = this.getSuperclasses(cls);
                if (superclasses == null) {
                    superclasses = new HashSet<IRI>();
                    this.classToSuperclassMap.put(cls, superclasses);
                }
                superclasses.add(superclass);
            }
        }
    }

    private void resetClasses() {
        this.classToSuperclassMap = null;
    }

    private Set<IRI> getSuperclasses(Resource cls) throws RDF4JException {
        this.initClasses();
        return this.classToSuperclassMap.get(cls);
    }

    @Override
    protected Model createModel() {
        return new LinkedHashModel();
    }

    @Override
    protected void addAxiomStatements() throws SailException {
        RDFInferencerInserter inserter = new RDFInferencerInserter(this, this.vf);
        if (this.axiomClosureNeeded) {
            schemaSpinFullFC.forEach(inserter::handleStatement);
        } else {
            schemaSp.forEach(inserter::handleStatement);
            schemaSpin.forEach(inserter::handleStatement);
            schemaSplSpin.forEach(inserter::handleStatement);
        }
    }

    private static List<Statement> getStatementsAsList(String resourceName, RDFFormat format) throws IOException {
        RDFParser parser = Rio.createParser(format);
        URL url = SpinSailConnection.class.getResource(resourceName);
        final ArrayList<Statement> ret = new ArrayList<Statement>();
        parser.setRDFHandler(new RDFHandler(){

            @Override
            public void startRDF() throws RDFHandlerException {
            }

            @Override
            public void endRDF() throws RDFHandlerException {
            }

            @Override
            public void handleNamespace(String s, String s1) throws RDFHandlerException {
            }

            @Override
            public void handleStatement(Statement statement) throws RDFHandlerException {
                ret.add(statement);
            }

            @Override
            public void handleComment(String s) throws RDFHandlerException {
            }
        });
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            parser.parse(in, url.toString());
        }
        return ret;
    }

    @Override
    protected void doInferencing() throws SailException {
        if (this.sail.isInitializing() && this.sail.isAxiomClosureNeeded()) {
            return;
        }
        this.ruleExecutions = new HashMap<Resource, Executions>();
        super.doInferencing();
        this.ruleExecutions = null;
    }

    @Override
    protected int applyRules(Model iteration) throws SailException {
        try {
            int nofInferred = 0;
            nofInferred += this.applyRulesInternal(iteration.subjects());
            return nofInferred += this.applyRulesInternal(Iterables.filter(iteration.objects(), Resource.class));
        }
        catch (SailException e) {
            throw e;
        }
        catch (RDF4JException e) {
            throw new SailException(e);
        }
    }

    private int applyRulesInternal(Iterable<Resource> resources) throws RDF4JException {
        int nofInferred = 0;
        for (Resource res : resources) {
            logger.debug("building class hierarchy for {}", (Object)res);
            Collection<IRI> remainingClasses = this.getClasses(res);
            ArrayList<IRI> classHierarchy = new ArrayList<IRI>(remainingClasses.size());
            while (!remainingClasses.isEmpty()) {
                boolean hasCycle = true;
                Iterator<IRI> clsIter = remainingClasses.iterator();
                while (clsIter.hasNext()) {
                    IRI cls = clsIter.next();
                    Set<IRI> superclasses = this.getSuperclasses(cls);
                    boolean isTerminal = true;
                    if (superclasses != null) {
                        for (IRI superclass : remainingClasses) {
                            if (superclass.equals(cls) || !superclasses.contains(superclass)) continue;
                            isTerminal = false;
                            break;
                        }
                    }
                    if (!isTerminal) continue;
                    classHierarchy.add(cls);
                    clsIter.remove();
                    hasCycle = false;
                }
                if (!hasCycle) continue;
                logger.warn("Cycle detected in class hierarchy: " + remainingClasses);
                classHierarchy.addAll(remainingClasses);
                break;
            }
            nofInferred += this.executeRules(res, classHierarchy);
            this.flushUpdates();
            nofInferred += this.executeConstructors(res, classHierarchy);
            this.flushUpdates();
            this.checkConstraints(res, classHierarchy);
        }
        return nofInferred;
    }

    private Collection<IRI> getClasses(Resource subj) throws QueryEvaluationException {
        return Iterations.asList(TripleSources.getObjectURIs(subj, RDF.TYPE, this.tripleSource));
    }

    private int executeConstructors(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        int nofInferred = 0;
        Set<Resource> constructed = Iterations.asSet(TripleSources.getObjectResources(subj, EXECUTED, this.tripleSource));
        for (IRI cls : classHierarchy) {
            List<Resource> constructors = this.getConstructorsForClass(cls);
            if (constructors.isEmpty()) continue;
            logger.trace("executing constructors for resource {} of class {}", (Object)subj, (Object)cls);
            for (Resource constructor : constructors) {
                if (!constructed.add(constructor)) continue;
                logger.trace("executing constructor {} for resource {}", (Object)constructor, (Object)subj);
                nofInferred += this.executeRule(subj, constructor);
                this.addInferredStatement(subj, EXECUTED, constructor, new Resource[0]);
            }
        }
        logger.trace("added {} new triples via constructors for resource {}", (Object)nofInferred, (Object)subj);
        return nofInferred;
    }

    private List<Resource> getConstructorsForClass(IRI cls) throws RDF4JException {
        return Iterations.asList(TripleSources.getObjectResources(cls, SPIN.CONSTRUCTOR_PROPERTY, this.tripleSource));
    }

    private int executeRules(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        int nofInferred = 0;
        List<IRI> ruleProps = this.getRuleProperties();
        for (IRI cls : classHierarchy) {
            Map<IRI, List<Resource>> classRulesByProperty = this.getRulesForClass(cls, ruleProps);
            if (classRulesByProperty.isEmpty()) continue;
            logger.debug("executing rules for resource {} of class {}", (Object)subj, (Object)cls);
            for (Map.Entry<IRI, List<Resource>> ruleEntry : classRulesByProperty.entrySet()) {
                RuleProperty ruleProperty = this.getRuleProperty(ruleEntry.getKey());
                int maxCount = ruleProperty.getMaxIterationCount();
                for (Resource rule : ruleEntry.getValue()) {
                    Executions executions = null;
                    if (maxCount != -1) {
                        executions = this.ruleExecutions.get(rule);
                        if (executions == null) {
                            executions = new Executions();
                            this.ruleExecutions.put(rule, executions);
                        }
                        if (executions.count >= maxCount) continue;
                    }
                    logger.trace("executing rule {} on resource {}", (Object)rule, (Object)subj);
                    nofInferred += this.executeRule(subj, rule);
                    if (executions == null) continue;
                    ++executions.count;
                }
            }
        }
        logger.debug("inferred {} new triples for resource {}", (Object)nofInferred, (Object)subj);
        return nofInferred;
    }

    private int executeRule(Resource subj, Resource rule) throws RDF4JException {
        return SpinInferencing.executeRule(subj, rule, this.queryPreparer, this.parser, this);
    }

    private Map<IRI, List<Resource>> getRulesForClass(IRI cls, List<IRI> ruleProps) throws QueryEvaluationException {
        HashMap<IRI, List<Resource>> classRulesByProperty = new HashMap<IRI, List<Resource>>(ruleProps.size() * 3);
        for (IRI ruleProp : ruleProps) {
            List<Resource> rules = Iterations.asList(TripleSources.getObjectResources(cls, ruleProp, this.tripleSource));
            if (rules.isEmpty()) continue;
            if (rules.size() > 1) {
                HashMap<Resource, String> comments = new HashMap<Resource, String>(rules.size() * 3);
                for (Resource rule : rules) {
                    String comment = this.getHighestComment(rule);
                    if (comment == null) continue;
                    comments.put(rule, comment);
                }
                rules.sort((rule1, rule2) -> {
                    String comment1 = (String)comments.get(rule1);
                    String comment2 = (String)comments.get(rule2);
                    if (comment1 != null && comment2 != null) {
                        return comment1.compareTo(comment2);
                    }
                    if (comment1 != null && comment2 == null) {
                        return 1;
                    }
                    if (comment1 == null && comment2 != null) {
                        return -1;
                    }
                    return 0;
                });
            }
            classRulesByProperty.put(ruleProp, rules);
        }
        return classRulesByProperty;
    }

    private String getHighestComment(Resource subj) throws QueryEvaluationException {
        String comment = null;
        try (CloseableIteration<Literal, QueryEvaluationException> iter = TripleSources.getObjectLiterals(subj, RDFS.COMMENT, this.tripleSource);){
            while (iter.hasNext()) {
                Literal l = (Literal)iter.next();
                String label = l.getLabel();
                if ((comment == null || label.compareTo(comment) <= 0) && comment != null) continue;
                comment = label;
            }
        }
        return comment;
    }

    private void checkConstraints(Resource subj, List<IRI> classHierarchy) throws RDF4JException {
        if (this.sail.isInitializing() || !this.sail.isValidateConstraints()) {
            return;
        }
        Map<IRI, List<Resource>> constraintsByClass = this.getConstraintsForSubject(subj, classHierarchy);
        if (!constraintsByClass.isEmpty()) {
            logger.debug("checking constraints for resource {}", (Object)subj);
            for (Map.Entry<IRI, List<Resource>> clsEntry : constraintsByClass.entrySet()) {
                List<Resource> constraints = clsEntry.getValue();
                for (Resource constraint : constraints) {
                    this.checkConstraint(subj, constraint);
                }
            }
        }
    }

    private void checkConstraint(Resource subj, Resource constraint) throws RDF4JException {
        logger.trace("checking constraint {} on resoure {}", (Object)constraint, (Object)subj);
        ConstraintViolation violation = SpinInferencing.checkConstraint(subj, constraint, this.queryPreparer, this.parser);
        if (violation != null) {
            this.handleConstraintViolation(violation);
        } else {
            logger.trace("no violation detected for resource {}", (Object)subj);
        }
    }

    protected void handleConstraintViolation(ConstraintViolation violation) throws ConstraintViolationException {
        switch (violation.getLevel()) {
            case INFO: {
                logger.info(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                break;
            }
            case WARNING: {
                logger.warn(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                break;
            }
            case ERROR: {
                logger.error(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                throw new ConstraintViolationException(violation);
            }
            case FATAL: {
                logger.error(constraintViolationMarker, CONSTRAINT_VIOLATION_MESSAGE, this.getConstraintViolationLogMessageArgs(violation));
                throw new ConstraintViolationException(violation);
            }
        }
    }

    private Object[] getConstraintViolationLogMessageArgs(ConstraintViolation violation) {
        return new Object[]{violation.getMessage() != null ? violation.getMessage() : "No message", Strings.nullToEmpty((String)violation.getRoot()), Strings.nullToEmpty((String)violation.getPath()), Strings.nullToEmpty((String)violation.getValue())};
    }

    private Map<IRI, List<Resource>> getConstraintsForSubject(Resource subj, List<IRI> classHierarchy) throws QueryEvaluationException {
        HashMap<IRI, List<Resource>> constraintsByClass = new HashMap<IRI, List<Resource>>(classHierarchy.size() * 3);
        for (IRI cls : classHierarchy) {
            List<Resource> constraints = this.getConstraintsForClass(cls);
            if (constraints.isEmpty()) continue;
            constraintsByClass.put(cls, constraints);
        }
        return constraintsByClass;
    }

    private List<Resource> getConstraintsForClass(Resource cls) throws QueryEvaluationException {
        return Iterations.asList(TripleSources.getObjectResources(cls, SPIN.CONSTRAINT_PROPERTY, this.tripleSource));
    }

    static {
        try {
            schemaSp = SpinSailConnection.getStatementsAsList("/schema/sp.ttl", RDFFormat.TURTLE);
            schemaSpin = SpinSailConnection.getStatementsAsList("/schema/spin.ttl", RDFFormat.TURTLE);
            schemaSplSpin = SpinSailConnection.getStatementsAsList("/schema/spl.spin.ttl", RDFFormat.TURTLE);
            schemaSpinFull = SpinSailConnection.getStatementsAsList("/schema/spin-full.ttl", RDFFormat.TURTLE);
            schemaSpinFullFC = SpinSailConnection.getStatementsAsList("/schema/spin-full-forwardchained.ttl", RDFFormat.TURTLE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Executions {
        int count;

        private Executions() {
        }
    }

    private class InvalidationListener
    implements SailConnectionListener {
        private InvalidationListener() {
        }

        @Override
        public void statementAdded(Statement st) {
            this.invalidate(st.getSubject());
        }

        @Override
        public void statementRemoved(Statement st) {
            this.invalidate(st.getSubject());
        }

        private void invalidate(Resource subj) {
            if (subj instanceof IRI) {
                TupleFunction tupleFunc;
                SpinSailConnection.this.parser.reset((IRI)subj);
                String key = subj.stringValue();
                Function func = SpinSailConnection.this.functionRegistry.get(key).orElse(null);
                if (func instanceof TransientFunction) {
                    SpinSailConnection.this.functionRegistry.remove(func);
                }
                if ((tupleFunc = (TupleFunction)SpinSailConnection.this.tupleFunctionRegistry.get(key).orElse(null)) instanceof TransientTupleFunction) {
                    SpinSailConnection.this.tupleFunctionRegistry.remove(tupleFunc);
                }
            }
        }
    }

    private class RulePropertyListener
    implements SailConnectionListener {
        private RulePropertyListener() {
        }

        @Override
        public void statementAdded(Statement st) {
            this.updateRuleProperties(st);
        }

        @Override
        public void statementRemoved(Statement st) {
            this.updateRuleProperties(st);
        }

        private void updateRuleProperties(Statement st) {
            boolean changed = false;
            IRI pred = st.getPredicate();
            if (RDFS.SUBPROPERTYOF.equals(pred) && SPIN.RULE_PROPERTY.equals(st.getObject())) {
                changed = true;
            } else if (SPIN.NEXT_RULE_PROPERTY_PROPERTY.equals(pred)) {
                changed = true;
            } else if (SPIN.RULE_PROPERTY_MAX_ITERATION_COUNT_PROPERTY.equals(pred)) {
                changed = true;
            }
            if (changed) {
                SpinSailConnection.this.resetRuleProperties();
            }
        }
    }

    private class SubclassListener
    implements SailConnectionListener {
        private SubclassListener() {
        }

        @Override
        public void statementAdded(Statement st) {
            if (st.getObject() instanceof Resource && RDFS.SUBCLASSOF.equals(st.getPredicate())) {
                SpinSailConnection.this.resetClasses();
            }
        }

        @Override
        public void statementRemoved(Statement st) {
            if (st.getObject() instanceof Resource && RDFS.SUBCLASSOF.equals(st.getPredicate())) {
                SpinSailConnection.this.resetClasses();
            }
        }
    }
}

