/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

@InternalUseOnly
public class ArrayBindingSet
extends AbstractBindingSet
implements MutableBindingSet {
    private static final long serialVersionUID = -1L;
    private final String[] bindingNames;
    private Set<String> bindingNamesSetCache;
    private final boolean[] whichBindingsHaveBeenSet;
    private final Value[] values;
    List<String> sortedBindingNames = null;

    public ArrayBindingSet(String ... names) {
        this.bindingNames = names;
        this.values = new Value[names.length];
        this.whichBindingsHaveBeenSet = new boolean[names.length];
    }

    public ArrayBindingSet(BindingSet toCopy, LinkedHashSet<String> names, String[] namesArray) {
        assert (!(toCopy instanceof ArrayBindingSet));
        Set<String> toCopyBindingNames = toCopy.getBindingNames();
        if (names.containsAll(toCopyBindingNames)) {
            this.bindingNames = namesArray;
            this.whichBindingsHaveBeenSet = new boolean[this.bindingNames.length];
            this.values = new Value[this.bindingNames.length];
            for (int i = 0; i < this.bindingNames.length; ++i) {
                Binding binding = toCopy.getBinding(this.bindingNames[i]);
                if (binding == null) continue;
                this.values[i] = binding.getValue();
                this.whichBindingsHaveBeenSet[i] = true;
            }
        } else {
            LinkedHashSet<String> newNames = new LinkedHashSet<String>();
            newNames.addAll(names);
            newNames.addAll(toCopyBindingNames);
            this.bindingNames = newNames.toArray(new String[0]);
            this.whichBindingsHaveBeenSet = new boolean[this.bindingNames.length];
            this.values = new Value[this.bindingNames.length];
            for (int i = 0; i < this.bindingNames.length; ++i) {
                Binding binding = toCopy.getBinding(this.bindingNames[i]);
                if (binding == null) continue;
                this.values[i] = binding.getValue();
                this.whichBindingsHaveBeenSet[i] = true;
            }
        }
    }

    public ArrayBindingSet(ArrayBindingSet toCopy, String ... names) {
        if (names == toCopy.bindingNames) {
            this.bindingNames = names;
        } else {
            LinkedHashSet<String> newNames = new LinkedHashSet<String>();
            newNames.addAll(Arrays.asList(names));
            newNames.addAll(toCopy.getBindingNames());
            this.bindingNames = newNames.toArray(new String[0]);
        }
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.whichBindingsHaveBeenSet = Arrays.copyOf(toCopy.whichBindingsHaveBeenSet, toCopy.whichBindingsHaveBeenSet.length);
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectSetBinding(String bindingName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            int idx = i;
            return (v, a) -> {
                a.values[idx] = v;
                a.whichBindingsHaveBeenSet[idx] = true;
                a.clearCache();
            };
        }
        assert (false) : "variable not known to ArrayBindingSet : " + bindingName;
        return null;
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectAddBinding(String bindingName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            int idx = i;
            return (v, a) -> {
                assert (!a.whichBindingsHaveBeenSet[idx]) : "variable already bound: " + bindingName;
                a.values[idx] = v;
                a.whichBindingsHaveBeenSet[idx] = true;
                a.clearCache();
            };
        }
        assert (false) : "variable not known to ArrayBindingSet : " + bindingName;
        return null;
    }

    public Function<ArrayBindingSet, Binding> getDirectGetBinding(String variableName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(variableName)) continue;
            int idx = i;
            return a -> {
                Value value = a.values[idx];
                if (value != null) {
                    return new SimpleBinding(variableName, value);
                }
                return null;
            };
        }
        return null;
    }

    public Function<ArrayBindingSet, Value> getDirectGetValue(String variableName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(variableName)) continue;
            int idx = i;
            return a -> a.values[idx];
        }
        return null;
    }

    public Function<ArrayBindingSet, Boolean> getDirectHasBinding(String bindingName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            int idx = i;
            return a -> a.whichBindingsHaveBeenSet[idx];
        }
        return null;
    }

    @Override
    public Set<String> getBindingNames() {
        if (this.bindingNamesSetCache == null) {
            int size = this.size();
            if (size == 0) {
                this.bindingNamesSetCache = Collections.emptySet();
            } else if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    this.bindingNamesSetCache = Collections.singleton(this.bindingNames[i]);
                    break;
                }
                assert (this.bindingNamesSetCache != null);
            } else {
                LinkedHashSet<String> bindingNamesSetCache = new LinkedHashSet<String>(size * 2);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    bindingNamesSetCache.add(this.bindingNames[i]);
                }
                this.bindingNamesSetCache = Collections.unmodifiableSet(bindingNamesSetCache);
            }
        }
        return this.bindingNamesSetCache;
    }

    @Override
    public Value getValue(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName) || !this.whichBindingsHaveBeenSet[i]) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            return this.whichBindingsHaveBeenSet[i];
        }
        return false;
    }

    @Override
    public Iterator<Binding> iterator() {
        return new ArrayBindingSetIterator();
    }

    @Override
    public int size() {
        int size = 0;
        for (boolean value : this.whichBindingsHaveBeenSet) {
            if (!value) continue;
            ++size;
        }
        return size;
    }

    public List<String> getSortedBindingNames() {
        if (this.sortedBindingNames == null) {
            int size = this.size();
            if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    this.sortedBindingNames = Collections.singletonList(this.bindingNames[i]);
                }
            } else {
                ArrayList<String> names = new ArrayList<String>(size);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (!this.whichBindingsHaveBeenSet[i]) continue;
                    names.add(this.bindingNames[i]);
                }
                names.sort(String::compareTo);
                this.sortedBindingNames = names;
            }
        }
        return this.sortedBindingNames;
    }

    @Override
    public void addBinding(Binding binding) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(binding.getName())) continue;
            assert (!this.whichBindingsHaveBeenSet[i]);
            this.values[i] = binding.getValue();
            this.whichBindingsHaveBeenSet[i] = true;
            this.clearCache();
            return;
        }
        assert (false) : "We don't actually support adding a binding.";
    }

    @Override
    public void setBinding(Binding binding) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(binding.getName())) continue;
            this.values[i] = binding.getValue();
            this.whichBindingsHaveBeenSet[i] = true;
            this.clearCache();
            return;
        }
    }

    @Override
    public void setBinding(String name, Value value) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(name)) continue;
            this.values[i] = value;
            this.whichBindingsHaveBeenSet[i] = value != null;
            this.clearCache();
            return;
        }
    }

    @Override
    public boolean isEmpty() {
        for (int index = 0; index < this.values.length; ++index) {
            if (!this.whichBindingsHaveBeenSet[index]) continue;
            return false;
        }
        return true;
    }

    private void clearCache() {
        this.bindingNamesSetCache = null;
    }

    private class ArrayBindingSetIterator
    implements Iterator<Binding> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            while (this.index < ArrayBindingSet.this.values.length) {
                if (ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public Binding next() {
            Value value;
            while (!(this.index >= ArrayBindingSet.this.values.length || ArrayBindingSet.this.whichBindingsHaveBeenSet[this.index] && ArrayBindingSet.this.values[this.index] != null)) {
                ++this.index;
            }
            String name = ArrayBindingSet.this.bindingNames[this.index];
            if ((value = ArrayBindingSet.this.values[this.index++]) != null) {
                return new SimpleBinding(name, value);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

