/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.rio.rdfxml.Att;
import org.eclipse.rdf4j.rio.rdfxml.Atts;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SAXFilter
implements ContentHandler {
    private final RDFXMLParser rdfParser;
    private Locator locator;
    private final Stack<ElementInfo> elInfoStack = new Stack();
    private final StringBuilder charBuf = new StringBuilder(512);
    private ParsedIRI documentURI;
    private boolean parseStandAloneDocuments = true;
    private ElementInfo deferredElement = null;
    private final Map<String, String> newNamespaceMappings = new LinkedHashMap<String, String>();
    private boolean inRDFContext;
    private int rdfContextStackHeight;
    private boolean parseLiteralMode = false;
    private int xmlLiteralStackHeight;
    private final List<String> xmlLiteralPrefixes = new ArrayList<String>();
    private final List<String> unknownPrefixesInXMLLiteral = new ArrayList<String>();

    public SAXFilter(RDFXMLParser rdfParser) {
        this.rdfParser = rdfParser;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void clear() {
        this.locator = null;
        this.elInfoStack.clear();
        this.charBuf.setLength(0);
        this.documentURI = null;
        this.deferredElement = null;
        this.newNamespaceMappings.clear();
        this.inRDFContext = false;
        this.rdfContextStackHeight = 0;
        this.parseLiteralMode = false;
        this.xmlLiteralStackHeight = 0;
        this.xmlLiteralPrefixes.clear();
        this.unknownPrefixesInXMLLiteral.clear();
    }

    public void setDocumentURI(String documentURI) {
        if (documentURI != null) {
            this.documentURI = this.createBaseURI(documentURI);
        }
    }

    public void setParseStandAloneDocuments(boolean standAloneDocs) {
        this.parseStandAloneDocuments = standAloneDocs;
    }

    public boolean getParseStandAloneDocuments() {
        return this.parseStandAloneDocuments;
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
        ParseLocationListener pll = this.rdfParser.getParseLocationListener();
        if (pll != null && loc != null) {
            pll.parseLocationUpdate(loc.getLineNumber(), loc.getColumnNumber());
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.rdfParser.startDocument();
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.rdfParser.endDocument();
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (this.deferredElement != null) {
                this.reportDeferredStartElement();
            }
            this.newNamespaceMappings.put(prefix, uri);
            if (this.parseLiteralMode) {
                this.xmlLiteralPrefixes.add(prefix);
            }
            if (this.rdfParser.getRDFHandler() != null) {
                this.rdfParser.getRDFHandler().handleNamespace(prefix, uri);
            }
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.parseLiteralMode) {
            this.xmlLiteralPrefixes.remove(prefix);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (this.deferredElement != null) {
                this.reportDeferredStartElement();
            }
            if (this.parseLiteralMode) {
                this.appendStartTag(qName, attributes);
                ++this.xmlLiteralStackHeight;
            } else {
                ElementInfo parent = this.peekStack();
                ElementInfo elInfo = new ElementInfo(parent, qName, namespaceURI, localName);
                elInfo.setNamespaceMappings(this.newNamespaceMappings);
                this.newNamespaceMappings.clear();
                if (!(this.inRDFContext || !this.parseStandAloneDocuments || localName.equals("RDF") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#"))) {
                    this.inRDFContext = true;
                }
                if (!this.inRDFContext) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String attQName = attributes.getQName(i);
                        if ("xml:base".equals(attQName)) {
                            elInfo.setBaseURI(attributes.getValue(i));
                            continue;
                        }
                        if (!"xml:lang".equals(attQName)) continue;
                        elInfo.xmlLang = attributes.getValue(i);
                    }
                    this.elInfoStack.push(elInfo);
                    if (localName.equals("RDF") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                        this.inRDFContext = true;
                        this.rdfContextStackHeight = 0;
                    }
                } else {
                    this.checkAndCopyAttributes(attributes, elInfo);
                    this.deferredElement = elInfo;
                }
                this.charBuf.setLength(0);
            }
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    private void reportDeferredStartElement() throws RDFParseException, RDFHandlerException {
        this.elInfoStack.push(this.deferredElement);
        ++this.rdfContextStackHeight;
        if (this.deferredElement.baseURI != null) {
            this.rdfParser.setBaseURI(this.deferredElement.baseURI.toString());
        }
        this.rdfParser.setXMLLang(this.deferredElement.xmlLang);
        this.rdfParser.startElement(this.deferredElement.namespaceURI, this.deferredElement.localName, this.deferredElement.qName, this.deferredElement.atts);
        this.deferredElement = null;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.rdfParser.getParserConfig().get(XMLParserSettings.FAIL_ON_MISMATCHED_TAGS).booleanValue() && !this.parseLiteralMode) {
                ElementInfo elInfo = this.deferredElement != null ? this.deferredElement : this.peekStack();
                if (!qName.equals(elInfo.qName)) {
                    this.rdfParser.reportError("expected end tag </'" + elInfo.qName + ">, found </" + qName + ">", XMLParserSettings.FAIL_ON_MISMATCHED_TAGS);
                }
            }
            if (!this.inRDFContext) {
                this.elInfoStack.pop();
                this.charBuf.setLength(0);
                return;
            }
            if (this.deferredElement == null && this.rdfContextStackHeight == 0) {
                this.inRDFContext = false;
                this.elInfoStack.pop();
                this.charBuf.setLength(0);
                return;
            }
            if (this.parseLiteralMode && this.xmlLiteralStackHeight > 0) {
                this.appendEndTag(qName);
                --this.xmlLiteralStackHeight;
                return;
            }
            if (this.deferredElement != null) {
                if (this.deferredElement.baseURI != null) {
                    this.rdfParser.setBaseURI(this.deferredElement.baseURI.toString());
                }
                this.rdfParser.setXMLLang(this.deferredElement.xmlLang);
                this.rdfParser.emptyElement(this.deferredElement.namespaceURI, this.deferredElement.localName, this.deferredElement.qName, this.deferredElement.atts);
                this.deferredElement = null;
            } else {
                if (this.parseLiteralMode) {
                    this.insertUsedContextPrefixes();
                    this.rdfParser.text(this.charBuf.toString());
                    this.parseLiteralMode = false;
                } else {
                    String s = this.charBuf.toString();
                    if (s.trim().length() > 0) {
                        this.rdfParser.text(s);
                    }
                }
                this.charBuf.setLength(0);
                this.elInfoStack.pop();
                --this.rdfContextStackHeight;
                this.rdfParser.endElement(namespaceURI, localName, qName);
            }
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.inRDFContext) {
                Att parseType;
                if (this.deferredElement != null && !this.parseLiteralMode && (parseType = this.deferredElement.atts.getAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null && parseType.getValue().equals("Literal")) {
                    this.setParseLiteralMode();
                }
                if (this.parseLiteralMode) {
                    if (this.deferredElement != null) {
                        this.reportDeferredStartElement();
                    }
                    String s = new String(ch, start, length);
                    s = XMLUtil.escapeCharacterData(s);
                    this.charBuf.append(s);
                } else {
                    this.charBuf.append(ch, start, length);
                    if (this.deferredElement != null && this.charBuf.toString().trim().length() > 0) {
                        this.reportDeferredStartElement();
                    }
                }
            }
        }
        catch (RDFHandlerException | RDFParseException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.parseLiteralMode) {
            this.charBuf.append(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    private void checkAndCopyAttributes(Attributes attributes, ElementInfo elInfo) throws SAXException, RDFParseException {
        Atts atts = new Atts(attributes.getLength());
        int attCount = attributes.getLength();
        for (int i = 0; i < attCount; ++i) {
            String qName = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (qName.startsWith("xml")) {
                if (qName.equals("xml:lang")) {
                    elInfo.xmlLang = value;
                    continue;
                }
                if (!qName.equals("xml:base")) continue;
                elInfo.setBaseURI(value);
                continue;
            }
            String namespace = attributes.getURI(i);
            String localName = attributes.getLocalName(i);
            if ("".equals(namespace) && (localName.equals("ID") || localName.equals("about") || localName.equals("resource") || localName.equals("parseType") || localName.equals("type"))) {
                this.rdfParser.reportWarning("use of unqualified attribute " + localName + " has been deprecated");
                namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            }
            if ("".equals(namespace)) {
                this.rdfParser.reportError("unqualified attribute '" + qName + "' not allowed", XMLParserSettings.FAIL_ON_INVALID_QNAME);
            }
            Att att = new Att(namespace, localName, qName, value);
            atts.addAtt(att);
        }
        elInfo.atts = atts;
    }

    public void setParseLiteralMode() {
        this.parseLiteralMode = true;
        this.xmlLiteralStackHeight = 0;
        this.xmlLiteralPrefixes.clear();
        this.unknownPrefixesInXMLLiteral.clear();
    }

    private ParsedIRI createBaseURI(String uriString) {
        return ParsedIRI.create(uriString).normalize();
    }

    private void appendStartTag(String qName, Attributes attributes) {
        String prefix;
        this.charBuf.append("<" + qName);
        for (Map.Entry<String, String> entry : this.newNamespaceMappings.entrySet()) {
            prefix = entry.getKey();
            String namespace = entry.getValue();
            this.appendNamespaceDecl(this.charBuf, prefix, namespace);
        }
        int attCount = attributes.getLength();
        for (int i = 0; i < attCount; ++i) {
            this.appendAttribute(this.charBuf, attributes.getQName(i), attributes.getValue(i));
        }
        this.charBuf.append(">");
        int colonIdx = qName.indexOf(58);
        String string = prefix = colonIdx > 0 ? qName.substring(0, colonIdx) : "";
        if (!this.xmlLiteralPrefixes.contains(prefix) && !this.unknownPrefixesInXMLLiteral.contains(prefix)) {
            this.unknownPrefixesInXMLLiteral.add(prefix);
        }
    }

    private void appendEndTag(String qName) {
        this.charBuf.append("</" + qName + ">");
    }

    private void insertUsedContextPrefixes() {
        int unknownPrefixesCount = this.unknownPrefixesInXMLLiteral.size();
        if (unknownPrefixesCount > 0) {
            int i;
            StringBuilder contextPrefixes = new StringBuilder(1024);
            ElementInfo topElement = this.peekStack();
            for (i = 0; i < unknownPrefixesCount; ++i) {
                String prefix = this.unknownPrefixesInXMLLiteral.get(i);
                String namespace = topElement.getNamespace(prefix);
                if (namespace == null) continue;
                this.appendNamespaceDecl(contextPrefixes, prefix, namespace);
            }
            int opentag = 0;
            for (i = 0; i < this.charBuf.length(); ++i) {
                char ch = this.charBuf.charAt(i);
                if (ch != '<' || i + 1 >= this.charBuf.length()) continue;
                char nextChar = this.charBuf.charAt(i + 1);
                if (nextChar != '/' && opentag == 0) {
                    ++opentag;
                    int endOfFirstStartTag = this.charBuf.substring(i).indexOf(">");
                    this.charBuf.insert(endOfFirstStartTag + i, contextPrefixes.toString());
                    continue;
                }
                --opentag;
            }
        }
        this.unknownPrefixesInXMLLiteral.clear();
    }

    private void appendNamespaceDecl(StringBuilder sb, String prefix, String namespace) {
        Object attName = "xmlns";
        if (!"".equals(prefix)) {
            attName = (String)attName + ":" + prefix;
        }
        this.appendAttribute(sb, (String)attName, namespace);
    }

    private void appendAttribute(StringBuilder sb, String name, String value) {
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(XMLUtil.escapeDoubleQuotedAttValue(value));
        sb.append("\"");
    }

    private ElementInfo peekStack() {
        ElementInfo result = null;
        if (!this.elInfoStack.empty()) {
            result = this.elInfoStack.peek();
        }
        return result;
    }

    private class ElementInfo {
        public String qName;
        public String namespaceURI;
        public String localName;
        public Atts atts;
        public ElementInfo parent;
        private Map<String, String> namespaceMap;
        public ParsedIRI baseURI;
        public String xmlLang;

        public ElementInfo(String qName, String namespaceURI, String localName) {
            this(null, qName, namespaceURI, localName);
        }

        public ElementInfo(ElementInfo parent, String qName, String namespaceURI, String localName) {
            this.parent = parent;
            this.qName = qName;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            if (parent != null) {
                this.baseURI = parent.baseURI;
                this.xmlLang = parent.xmlLang;
            } else {
                this.baseURI = SAXFilter.this.documentURI;
                this.xmlLang = "";
            }
        }

        public void setBaseURI(String uriString) {
            this.baseURI = this.baseURI != null ? this.baseURI.resolve(SAXFilter.this.createBaseURI(uriString)) : SAXFilter.this.createBaseURI(uriString);
        }

        public void setNamespaceMappings(Map<String, String> namespaceMappings) {
            this.namespaceMap = namespaceMappings.isEmpty() ? null : new HashMap<String, String>(namespaceMappings);
        }

        public String getNamespace(String prefix) {
            String result = null;
            if (this.namespaceMap != null) {
                result = this.namespaceMap.get(prefix);
            }
            if (result == null && this.parent != null) {
                result = this.parent.getNamespace(prefix);
            }
            return result;
        }
    }
}

