/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class BindingSetAssignment
extends AbstractQueryModelNode
implements TupleExpr {
    private Set<String> bindingNames;
    private Iterable<BindingSet> bindingSets;

    @Override
    public Set<String> getBindingNames() {
        return this.getAssuredBindingNames();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        if (this.bindingNames == null) {
            this.bindingNames = this.findBindingNames();
        }
        return this.bindingNames;
    }

    private Set<String> findBindingNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.bindingSets != null) {
            for (BindingSet set : this.bindingSets) {
                result.addAll(set.getBindingNames());
            }
        }
        return result;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BindingSetAssignment)) {
            return false;
        }
        BindingSetAssignment other = (BindingSetAssignment)obj;
        return Objects.equals(this.bindingNames, other.bindingNames) && Objects.equals(this.bindingSets, other.bindingSets);
    }

    public int hashCode() {
        return Objects.hash(this.bindingNames, this.bindingSets);
    }

    @Override
    public BindingSetAssignment clone() {
        return (BindingSetAssignment)super.clone();
    }

    public void setBindingNames(Set<String> bindingNames) {
        this.bindingNames = bindingNames;
    }

    public void setBindingSets(Iterable<BindingSet> bindingSets) {
        this.bindingSets = bindingSets;
    }

    public Iterable<BindingSet> getBindingSets() {
        return this.bindingSets;
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " (" + this.getBindingSets().toString() + ")";
    }

    @Override
    protected boolean shouldCacheCardinality() {
        return true;
    }
}

