/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.QueryParser;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;

public class SparqlQueryParserCache {
    private static final Cache<String, TupleExpr> PARSER_QUERY_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(Runtime.getRuntime().availableProcessors() * 2).maximumSize(10000L).build();
    private static final QueryParser QUERY_PARSER;

    public static TupleExpr get(String query) {
        try {
            return ((TupleExpr)PARSER_QUERY_CACHE.get((Object)query, () -> QUERY_PARSER.parseQuery(query, null).getTupleExpr())).clone();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MalformedQueryException) {
                throw (MalformedQueryException)e.getCause();
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause != null) {
                throw new IllegalStateException(cause);
            }
            throw new IllegalStateException(e);
        }
    }

    static {
        Optional queryParserFactory = QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL);
        QUERY_PARSER = ((QueryParserFactory)queryParserFactory.orElseThrow(() -> new IllegalStateException("Query parser factory for SPARQL is missing!"))).getParser();
    }
}

