/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterByPredicate;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;

public class TargetSubjectsOf
extends Target {
    private final Set<IRI> targetSubjectsOf;

    public TargetSubjectsOf(Set<IRI> targetSubjectsOf) {
        this.targetSubjectsOf = targetSubjectsOf;
        assert (!this.targetSubjectsOf.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_SUBJECTS_OF;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetSubjectsOf.forEach(t -> model.add(subject, this.getPredicate(), (Value)t, new Resource[0]));
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup.getAddedStatements(), dataGraph, scope);
    }

    private PlanNode getAddedRemovedInner(SailConnection connection, Resource[] dataGraph, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.targetSubjectsOf.stream().map(predicate -> new UnorderedSelect(connection, null, (IRI)predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope))).reduce((xva$0, xva$1) -> UnionNode.getInstance(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(planNode, false);
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        String tempVar = stableRandomVariableProvider.next().asSparqlVariable();
        return this.targetSubjectsOf.stream().map(target -> "{\nBIND(<" + target + "> as " + tempVar + ")\n" + subjectVariable + " " + tempVar + " " + objectVariable + ".\n}").reduce((a, b) -> a + " UNION " + b).get();
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, Resource[] dataGraph, PlanNode parent) {
        return new FilterByPredicate(connectionsGroup.getBaseConnection(), this.targetSubjectsOf, parent, FilterByPredicate.On.Subject, dataGraph);
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        return this.targetSubjectsOf.stream().map(t -> new StatementMatcher(object, new StatementMatcher.Variable((Value)t), null));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        assert (subject == null);
        String tempVar = stableRandomVariableProvider.next().asSparqlVariable();
        if (this.targetSubjectsOf.size() == 1) {
            return this.targetSubjectsOf.stream().map(t -> "?" + object.getName() + " <" + t + "> " + tempVar + " .").reduce((a, b) -> a + "\n" + b).orElse("");
        }
        String in = this.targetSubjectsOf.stream().map(t -> "<" + t + ">").reduce((a, b) -> a + " , " + b).orElse("");
        return "?" + object.getName() + " ?predicatefjhfuewhw " + tempVar + " .\nFILTER(?predicatefjhfuewhw in (" + in + "))";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetSubjectsOf that = (TargetSubjectsOf)o;
        return this.targetSubjectsOf.equals(that.targetSubjectsOf);
    }

    public int hashCode() {
        return Objects.hash(this.targetSubjectsOf);
    }
}

