/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchIndex;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchSpatialSupport;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchDocument
implements SearchDocument {
    private final String id;
    private final String type;
    private final long version;
    private final String index;
    private final Map<String, Object> fields;
    private final Function<? super String, ? extends SpatialContext> geoContextMapper;

    @Deprecated
    public ElasticsearchDocument(SearchHit hit) {
        this(hit, null);
    }

    public ElasticsearchDocument(SearchHit hit, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this(hit.getId(), hit.getType(), hit.getIndex(), hit.getVersion(), hit.getSource(), geoContextMapper);
    }

    public ElasticsearchDocument(String id, String type, String index, String resourceId, String context, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this(id, type, index, 0L, new HashMap<String, Object>(), geoContextMapper);
        this.fields.put("uri", resourceId);
        if (context != null) {
            this.fields.put("context", context);
        }
    }

    public ElasticsearchDocument(String id, String type, String index, long version, Map<String, Object> fields, Function<? super String, ? extends SpatialContext> geoContextMapper) {
        this.id = id;
        this.type = type;
        this.version = version;
        this.index = index;
        this.fields = fields;
        this.geoContextMapper = geoContextMapper;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public long getVersion() {
        return this.version;
    }

    public String getIndex() {
        return this.index;
    }

    public Map<String, Object> getSource() {
        return this.fields;
    }

    public String getResource() {
        return (String)this.fields.get("uri");
    }

    public String getContext() {
        return (String)this.fields.get("context");
    }

    public Set<String> getPropertyNames() {
        return ElasticsearchIndex.getPropertyFields(this.fields.keySet());
    }

    public void addProperty(String name) {
        if (this.fields.containsKey(name)) {
            throw new IllegalStateException("Property already added: " + name);
        }
        this.fields.put(name, null);
        if (!this.fields.containsKey("text")) {
            this.fields.put("text", null);
        }
    }

    public void addProperty(String name, String text) {
        ElasticsearchDocument.addField(name, text, this.fields);
        ElasticsearchDocument.addField("text", text, this.fields);
    }

    public void addGeoProperty(String name, String text) {
        ElasticsearchDocument.addField(name, text, this.fields);
        try {
            Shape shape = ((SpatialContext)this.geoContextMapper.apply((Object)name)).readShapeFromWkt(text);
            if (shape instanceof Point) {
                Point p = (Point)shape;
                this.fields.put("_geopoint_" + name, GeoHashUtils.encode((double)p.getY(), (double)p.getX()));
            } else {
                this.fields.put("_geoshape_" + name, ElasticsearchSpatialSupport.getSpatialSupport().toGeoJSON(shape));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean hasProperty(String name, String value) {
        List<String> fieldValues = ElasticsearchDocument.asStringList(this.fields.get(name));
        if (fieldValues != null) {
            for (String fieldValue : fieldValues) {
                if (!value.equals(fieldValue)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProperty(String name) {
        return ElasticsearchDocument.asStringList(this.fields.get(name));
    }

    private static void addField(String name, String value, Map<String, Object> document) {
        Object newValue;
        Object oldValue = document.get(name);
        if (oldValue != null) {
            List<String> newList = ElasticsearchDocument.makeModifiable(ElasticsearchDocument.asStringList(oldValue));
            newList.add(value);
            newValue = newList;
        } else {
            newValue = value;
        }
        document.put(name, newValue);
    }

    private static List<String> makeModifiable(List<String> l) {
        List<String> modList;
        if (!(l instanceof ArrayList)) {
            modList = new ArrayList<String>(l.size() + 1);
            modList.addAll(l);
        } else {
            modList = l;
        }
        return modList;
    }

    private static List<String> asStringList(Object value) {
        List<String> l = value == null ? null : (value instanceof List ? (List<String>)value : Collections.singletonList((String)value));
        return l;
    }
}

