/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocument;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.search.SearchHit;

public class ElasticsearchDocumentDistance
extends ElasticsearchDocumentResult
implements DocumentDistance {
    private final String geoPointField;
    private final URI units;
    private final GeoDistance.FixedSourceDistance srcDistance;
    private final DistanceUnit unit;

    public ElasticsearchDocumentDistance(SearchHit hit, Function<? super String, ? extends SpatialContext> geoContextMapper, String geoPointField, URI units, GeoDistance.FixedSourceDistance srcDistance, DistanceUnit unit) {
        super(hit, geoContextMapper);
        this.geoPointField = geoPointField;
        this.units = units;
        this.srcDistance = srcDistance;
        this.unit = unit;
    }

    public double getDistance() {
        double distance;
        String geohash = (String)((ElasticsearchDocument)this.getDocument()).getSource().get(this.geoPointField);
        GeoPoint point = GeoHashUtils.decode((String)geohash);
        double unitDist = this.srcDistance.calculate(point.getLat(), point.getLon());
        if (GEOF.UOM_METRE.equals((Object)this.units)) {
            distance = this.unit.toMeters(unitDist);
        } else if (GEOF.UOM_DEGREE.equals((Object)this.units)) {
            distance = unitDist / this.unit.getDistancePerDegree();
        } else if (GEOF.UOM_RADIAN.equals((Object)this.units)) {
            distance = DistanceUtils.dist2Radians((double)this.unit.convert(unitDist, DistanceUnit.KILOMETERS), (double)6371.0087714);
        } else if (GEOF.UOM_UNITY.equals((Object)this.units)) {
            distance = this.unit.convert(unitDist, DistanceUnit.KILOMETERS) / 20015.114352186374;
        } else {
            throw new UnsupportedOperationException("Unsupported units: " + this.units);
        }
        return distance;
    }
}

