/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.List;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;

public class DistanceQuerySpec
implements SearchQueryEvaluator {
    private QueryModelNode functionParent;
    private Literal from;
    private URI units;
    private double distance;
    private String distanceVar;
    private StatementPattern geoStatement;
    private Filter filter;

    public void setFunctionParent(QueryModelNode functionParent) {
        this.functionParent = functionParent;
    }

    public void setFrom(Literal from) {
        this.from = from;
    }

    public Literal getFrom() {
        return this.from;
    }

    public void setUnits(URI units) {
        this.units = units;
    }

    public URI getUnits() {
        return this.units;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistanceVar(String varName) {
        this.distanceVar = varName;
    }

    public String getDistanceVar() {
        return this.distanceVar;
    }

    public void setGeometryPattern(StatementPattern sp) {
        if (sp.getSubjectVar().hasValue()) {
            throw new IllegalArgumentException("Subject cannot be bound: " + sp);
        }
        if (!sp.getPredicateVar().hasValue()) {
            throw new IllegalArgumentException("Predicate must be bound: " + sp);
        }
        if (sp.getObjectVar().hasValue()) {
            throw new IllegalArgumentException("Object cannot be bound: " + sp);
        }
        this.geoStatement = sp;
    }

    public String getSubjectVar() {
        return this.geoStatement.getSubjectVar().getName();
    }

    public Var getContextVar() {
        return this.geoStatement.getContextVar();
    }

    public URI getGeoProperty() {
        return (URI)this.geoStatement.getPredicateVar().getValue();
    }

    public String getGeoVar() {
        return this.geoStatement.getObjectVar().getName();
    }

    public void setFilter(Filter f) {
        this.filter = f;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryModelNode getParentQueryModelNode() {
        return this.filter;
    }

    @Override
    public void updateQueryModelNodes(boolean hasResult) {
        SingletonSet replacementNode = hasResult ? new SingletonSet() : new EmptySet();
        this.geoStatement.replaceWith((QueryModelNode)replacementNode);
        if (hasResult) {
            this.filter.replaceWith((QueryModelNode)this.filter.getArg());
        } else {
            this.filter.replaceWith((QueryModelNode)new EmptySet());
        }
        if (this.functionParent instanceof ExtensionElem) {
            Extension extension = (Extension)this.functionParent.getParentNode();
            List elements = extension.getElements();
            if (elements.size() > 1) {
                elements.remove(this.functionParent);
            } else {
                extension.replaceWith((QueryModelNode)extension.getArg());
            }
        }
    }
}

