/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelVisitorBase;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;

public class DistanceQuerySpecBuilder
implements SearchQueryInterpreter {
    private SearchIndex index;

    public DistanceQuerySpecBuilder(SearchIndex index) {
        this.index = index;
    }

    @Override
    public void process(TupleExpr tupleExpr, BindingSet bindings, final Collection<SearchQueryEvaluator> results) throws SailException {
        tupleExpr.visit((QueryModelVisitor)new QueryModelVisitorBase<SailException>(){
            final Map<String, DistanceQuerySpec> specs = new HashMap<String, DistanceQuerySpec>();

            public void meet(FunctionCall f) throws SailException {
                if (GEOF.DISTANCE.stringValue().equals(f.getURI())) {
                    List args = f.getArgs();
                    if (args.size() != 3) {
                        return;
                    }
                    Literal from = DistanceQuerySpecBuilder.getLiteral((ValueExpr)args.get(0));
                    String to = DistanceQuerySpecBuilder.getVarName((ValueExpr)args.get(1));
                    URI units = DistanceQuerySpecBuilder.getURI((ValueExpr)args.get(2));
                    if (from == null || to == null || units == null) {
                        return;
                    }
                    Filter filter = null;
                    Literal dist = null;
                    String distanceVar = null;
                    QueryModelNode parent = f.getParentNode();
                    if (parent instanceof ExtensionElem) {
                        distanceVar = ((ExtensionElem)parent).getName();
                        QueryModelNode extension = parent.getParentNode();
                        Object[] rv = DistanceQuerySpecBuilder.getFilterAndDistance(extension.getParentNode(), distanceVar);
                        if (rv == null) {
                            return;
                        }
                        filter = (Filter)rv[0];
                        dist = (Literal)rv[1];
                    } else if (parent instanceof Compare) {
                        filter = (Filter)parent.getParentNode();
                        Compare compare = (Compare)parent;
                        Compare.CompareOp op = compare.getOperator();
                        if (op == Compare.CompareOp.LT && compare.getLeftArg() == f) {
                            dist = DistanceQuerySpecBuilder.getLiteral(compare.getRightArg());
                        } else if (op == Compare.CompareOp.GT && compare.getRightArg() == f) {
                            dist = DistanceQuerySpecBuilder.getLiteral(compare.getLeftArg());
                        }
                    }
                    if (dist == null || !XMLSchema.DOUBLE.equals((Object)dist.getDatatype())) {
                        return;
                    }
                    DistanceQuerySpec spec = new DistanceQuerySpec();
                    spec.setFunctionParent(parent);
                    spec.setFrom(from);
                    spec.setUnits(units);
                    spec.setDistance(dist.doubleValue());
                    spec.setDistanceVar(distanceVar);
                    spec.setFilter(filter);
                    this.specs.put(to, spec);
                }
            }

            public void meet(StatementPattern sp) {
                String objectVarName;
                DistanceQuerySpec spec;
                URI propertyName = (URI)sp.getPredicateVar().getValue();
                if (propertyName != null && DistanceQuerySpecBuilder.this.index.isGeoField(SearchFields.getPropertyField(propertyName)) && !sp.getObjectVar().hasValue() && (spec = this.specs.remove(objectVarName = sp.getObjectVar().getName())) != null && DistanceQuerySpecBuilder.isChildOf((QueryModelNode)sp, (QueryModelNode)spec.getFilter())) {
                    spec.setGeometryPattern(sp);
                    results.add(spec);
                }
            }
        });
    }

    private static boolean isChildOf(QueryModelNode child, QueryModelNode parent) {
        if (child.getParentNode() == parent) {
            return true;
        }
        return DistanceQuerySpecBuilder.isChildOf(child.getParentNode(), parent);
    }

    private static Object[] getFilterAndDistance(QueryModelNode node, String compareArgVarName) {
        Object[] rv = null;
        if (node instanceof Filter) {
            Filter f = (Filter)node;
            ValueExpr condition = f.getCondition();
            if (condition instanceof Compare) {
                Compare compare = (Compare)condition;
                Compare.CompareOp op = compare.getOperator();
                Literal dist = null;
                if (op == Compare.CompareOp.LT && compareArgVarName.equals(DistanceQuerySpecBuilder.getVarName(compare.getLeftArg()))) {
                    dist = DistanceQuerySpecBuilder.getLiteral(compare.getRightArg());
                } else if (op == Compare.CompareOp.GT && compareArgVarName.equals(DistanceQuerySpecBuilder.getVarName(compare.getRightArg()))) {
                    dist = DistanceQuerySpecBuilder.getLiteral(compare.getLeftArg());
                }
                rv = new Object[]{f, dist};
            }
        } else if (node != null) {
            rv = DistanceQuerySpecBuilder.getFilterAndDistance(node.getParentNode(), compareArgVarName);
        }
        return rv;
    }

    private static Literal getLiteral(ValueExpr v) {
        Value value = DistanceQuerySpecBuilder.getValue(v);
        if (value instanceof Literal) {
            return (Literal)value;
        }
        return null;
    }

    private static URI getURI(ValueExpr v) {
        Value value = DistanceQuerySpecBuilder.getValue(v);
        if (value instanceof URI) {
            return (URI)value;
        }
        return null;
    }

    private static Value getValue(ValueExpr v) {
        Value value = null;
        if (v instanceof ValueConstant) {
            value = ((ValueConstant)v).getValue();
        } else if (v instanceof Var) {
            value = ((Var)v).getValue();
        }
        return value;
    }

    private static String getVarName(ValueExpr v) {
        Var var;
        if (v instanceof Var && !(var = (Var)v).isConstant()) {
            return var.getName();
        }
        return null;
    }
}

