/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.GeoRelationQuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.IndexableStatementFilter;
import org.eclipse.rdf4j.sail.lucene.LuceneSailConnection;
import org.eclipse.rdf4j.sail.lucene.QuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSail
extends NotifyingSailWrapper {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String REINDEX_QUERY_KEY = "reindexQuery";
    public static final String INDEXEDFIELDS = "indexedfields";
    public static final String LUCENE_DIR_KEY = "lucenedir";
    public static final String LUCENE_RAMDIR_KEY = "useramdir";
    public static final String MAX_DOCUMENTS_KEY = "maxDocuments";
    public static final String WKT_FIELDS = "wktFields";
    public static final String INDEX_CLASS_KEY = "index";
    public static final String DEFAULT_INDEX_CLASS = "org.eclipse.rdf4j.sail.lucene.LuceneIndex";
    public static final String ANALYZER_CLASS_KEY = "analyzer";
    public static final String INCOMPLETE_QUERY_FAIL_KEY = "incompletequeryfail";
    private volatile SearchIndex luceneIndex;
    protected final Properties parameters = new Properties();
    private volatile String reindexQuery = "SELECT ?s ?p ?o ?c WHERE {{?s ?p ?o} UNION {GRAPH ?c {?s ?p ?o.}}} ORDER BY ?s";
    private volatile boolean incompleteQueryFails = true;
    private Set<IRI> indexedFields;
    private Map<IRI, IRI> indexedFieldsMapping;
    private IndexableStatementFilter filter = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public void setLuceneIndex(SearchIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public SearchIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public NotifyingSailConnection getConnection() throws SailException {
        if (!this.closed.get()) {
            return new LuceneSailConnection(super.getConnection(), this.luceneIndex, this);
        }
        throw new SailException("Sail is shut down or not initialized");
    }

    public void shutDown() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            this.logger.debug("LuceneSail shutdown");
            try {
                SearchIndex toShutDownLuceneIndex = this.luceneIndex;
                this.luceneIndex = null;
                if (toShutDownLuceneIndex != null) {
                    toShutDownLuceneIndex.shutDown();
                }
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            finally {
                super.shutDown();
            }
        }
    }

    public void setDataDir(File dataDir) {
        this.setParameter(LUCENE_DIR_KEY, dataDir.getAbsolutePath() + ".index");
        this.getBaseSail().setDataDir(dataDir);
    }

    public void initialize() throws SailException {
        super.initialize();
        if (this.parameters.containsKey(INDEXEDFIELDS)) {
            String indexedfieldsString = this.parameters.getProperty(INDEXEDFIELDS);
            Properties prop = new Properties();
            try {
                StringReader reader = new StringReader(indexedfieldsString);
                prop.load(reader);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new SailException("Could read indexedfields: " + indexedfieldsString, (Throwable)e);
            }
            ValueFactory vf = this.getValueFactory();
            this.indexedFields = new HashSet<IRI>();
            this.indexedFieldsMapping = new HashMap<IRI, IRI>();
            for (Object key : prop.keySet()) {
                String keyStr = key.toString();
                if (keyStr.startsWith("index.")) {
                    this.indexedFields.add(vf.createIRI(prop.getProperty(keyStr)));
                    continue;
                }
                this.indexedFieldsMapping.put(vf.createIRI(keyStr), vf.createIRI(prop.getProperty(keyStr)));
            }
        }
        try {
            if (this.parameters.containsKey(REINDEX_QUERY_KEY)) {
                this.setReindexQuery(this.parameters.getProperty(REINDEX_QUERY_KEY));
            }
            if (this.parameters.containsKey(INCOMPLETE_QUERY_FAIL_KEY)) {
                this.setIncompleteQueryFails(Boolean.parseBoolean(this.parameters.getProperty(INCOMPLETE_QUERY_FAIL_KEY)));
            }
            if (this.luceneIndex == null) {
                this.initializeLuceneIndex();
            }
        }
        catch (Exception e) {
            throw new SailException("Could not initialize LuceneSail: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void initializeLuceneIndex() throws Exception {
        String indexClassName = this.parameters.getProperty(INDEX_CLASS_KEY, DEFAULT_INDEX_CLASS);
        SearchIndex index = (SearchIndex)Class.forName(indexClassName).newInstance();
        index.initialize(this.parameters);
        this.setLuceneIndex(index);
    }

    public void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public Set<String> getParameterNames() {
        return this.parameters.stringPropertyNames();
    }

    public String getReindexQuery() {
        return this.reindexQuery;
    }

    public void setReindexQuery(String query) {
        this.setParameter(REINDEX_QUERY_KEY, query);
        this.reindexQuery = query;
    }

    public boolean isIncompleteQueryFails() {
        return this.incompleteQueryFails;
    }

    public void setIncompleteQueryFails(boolean incompleteQueryFails) {
        this.setParameter(INCOMPLETE_QUERY_FAIL_KEY, Boolean.toString(incompleteQueryFails));
        this.incompleteQueryFails = incompleteQueryFails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex() throws Exception {
        this.logger.info("Reindexing sail: clearing...");
        this.luceneIndex.clear();
        this.logger.info("Reindexing sail: adding...");
        this.luceneIndex.begin();
        try {
            SailRepository repo = new SailRepository((Sail)new NotifyingSailWrapper(this.getBaseSail()){

                public void shutDown() {
                }
            });
            SailRepositoryConnection connection = repo.getConnection();
            try {
                TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, this.reindexQuery);
                TupleQueryResult res = query.evaluate();
                Resource current = null;
                ValueFactory vf = this.getValueFactory();
                ArrayList<Statement> statements = new ArrayList<Statement>();
                while (res.hasNext()) {
                    BindingSet set = (BindingSet)res.next();
                    Resource r = (Resource)set.getValue("s");
                    IRI p = (IRI)set.getValue("p");
                    Value o = set.getValue("o");
                    Resource c = (Resource)set.getValue("c");
                    if (current == null) {
                        current = r;
                    } else if (!current.equals(r)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("reindexing resource " + current);
                        }
                        this.luceneIndex.addDocuments(current, statements);
                        current = r;
                        statements.clear();
                    }
                    statements.add(vf.createStatement(r, p, o, c));
                }
            }
            finally {
                connection.close();
                repo.shutDown();
            }
            this.luceneIndex.commit();
            this.logger.info("Reindexing sail: done.");
        }
        catch (Exception e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    public void registerStatementFilter(IndexableStatementFilter filter) {
        this.filter = filter;
    }

    protected boolean acceptStatementToIndex(Statement s) {
        IndexableStatementFilter nextFilter = this.filter;
        return nextFilter != null ? nextFilter.accept(s) : true;
    }

    public Statement mapStatement(Statement statement) {
        Set<IRI> nextIndexedFields;
        IRI res;
        IRI p = statement.getPredicate();
        boolean predicateChanged = false;
        Map<IRI, IRI> nextIndexedFieldsMapping = this.indexedFieldsMapping;
        if (nextIndexedFieldsMapping != null && (res = nextIndexedFieldsMapping.get(p)) != null) {
            p = res;
            predicateChanged = true;
        }
        if ((nextIndexedFields = this.indexedFields) != null && !nextIndexedFields.contains(p)) {
            return null;
        }
        if (predicateChanged) {
            return this.getValueFactory().createStatement(statement.getSubject(), p, statement.getObject(), statement.getContext());
        }
        return statement;
    }

    protected Collection<SearchQueryInterpreter> getSearchQueryInterpreters() {
        return Arrays.asList(new QuerySpecBuilder(this.incompleteQueryFails), new DistanceQuerySpecBuilder(this.luceneIndex), new GeoRelationQuerySpecBuilder(this.luceneIndex));
    }
}

