/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.BindingSetCollection;
import org.eclipse.rdf4j.sail.lucene.LuceneSail;
import org.eclipse.rdf4j.sail.lucene.LuceneSailBuffer;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSailConnection
extends NotifyingSailConnectionWrapper {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SearchIndex luceneIndex;
    private final LuceneSail sail;
    private final LuceneSailBuffer buffer = new LuceneSailBuffer();
    protected final SailConnectionListener connectionListener = new SailConnectionListener(){

        public void statementAdded(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.add(statement);
                }
            }
        }

        public void statementRemoved(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                statement = LuceneSailConnection.this.sail.mapStatement(statement);
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSailConnection.this.buffer.remove(statement);
                }
            }
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneSailConnection(NotifyingSailConnection wrappedConnection, SearchIndex luceneIndex, LuceneSail sail) {
        super(wrappedConnection);
        this.luceneIndex = luceneIndex;
        this.sail = sail;
        wrappedConnection.addConnectionListener(this.connectionListener);
    }

    public synchronized void addStatement(Resource arg0, IRI arg1, Value arg2, Resource ... arg3) throws SailException {
        super.addStatement(arg0, arg1, arg2, arg3);
    }

    public void close() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                super.close();
            }
            finally {
                try {
                    this.luceneIndex.endReading();
                }
                catch (IOException e) {
                    this.logger.warn("could not close IndexReader or IndexSearcher " + e, (Throwable)e);
                }
            }
        }
    }

    public synchronized void clear(Resource ... arg0) throws SailException {
        this.getWrappedConnection().removeConnectionListener(this.connectionListener);
        try {
            super.clear(arg0);
            this.buffer.clear(arg0);
        }
        finally {
            this.getWrappedConnection().addConnectionListener(this.connectionListener);
        }
    }

    public void begin() throws SailException {
        super.begin();
        this.buffer.reset();
        try {
            this.luceneIndex.begin();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SailException {
        super.commit();
        this.logger.debug("Committing Lucene transaction with {} operations.", (Object)this.buffer.operations().size());
        try {
            try {
                this.buffer.optimize();
                Iterator<LuceneSailBuffer.Operation> i = this.buffer.operations().iterator();
                while (i.hasNext()) {
                    LuceneSailBuffer.Operation op = i.next();
                    if (op instanceof LuceneSailBuffer.AddRemoveOperation) {
                        LuceneSailBuffer.AddRemoveOperation addremove = (LuceneSailBuffer.AddRemoveOperation)op;
                        this.addRemoveStatements(addremove.getAdded(), addremove.getRemoved());
                    } else if (op instanceof LuceneSailBuffer.ClearContextOperation) {
                        this.clearContexts(((LuceneSailBuffer.ClearContextOperation)op).getContexts());
                    } else if (op instanceof LuceneSailBuffer.ClearOperation) {
                        this.logger.debug("clearing index...");
                        this.luceneIndex.clear();
                    } else {
                        throw new RuntimeException("Cannot interpret operation " + op + " of type " + op.getClass().getName());
                    }
                    i.remove();
                }
            }
            catch (Exception e) {
                this.logger.error("Committing operations in lucenesail, encountered exception " + e + ". Only some operations were stored, " + this.buffer.operations().size() + " operations are discarded. Lucene Index is now corrupt.", (Throwable)e);
                throw new SailException((Throwable)e);
            }
        }
        finally {
            this.buffer.reset();
        }
    }

    private void addRemoveStatements(Set<Statement> toAdd, Set<Statement> toRemove) throws IOException {
        this.logger.debug("indexing {}/removing {} statements...", (Object)toAdd.size(), (Object)toRemove.size());
        this.luceneIndex.begin();
        try {
            this.luceneIndex.addRemoveStatements(toAdd, toRemove);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    private void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("clearing contexts...");
        this.luceneIndex.begin();
        try {
            this.luceneIndex.clearContexts(contexts);
            this.luceneIndex.commit();
        }
        catch (IOException e) {
            this.logger.error("Rolling back", (Throwable)e);
            this.luceneIndex.rollback();
            throw e;
        }
    }

    public synchronized CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        tupleExpr = tupleExpr.clone();
        new BindingAssigner().optimize(tupleExpr, dataset, bindings);
        ArrayList<SearchQueryEvaluator> queries = new ArrayList<SearchQueryEvaluator>();
        for (SearchQueryInterpreter interpreter : this.sail.getSearchQueryInterpreters()) {
            interpreter.process(tupleExpr, bindings, queries);
        }
        if (!queries.isEmpty()) {
            this.evaluateLuceneQueries(queries, tupleExpr);
        }
        return super.evaluate(tupleExpr, dataset, bindings, includeInferred);
    }

    private void evaluateLuceneQueries(Collection<SearchQueryEvaluator> queries, TupleExpr tupleExpr) throws SailException {
        if (this.closed.get()) {
            throw new SailException("Sail has been closed already");
        }
        try {
            this.luceneIndex.beginReading();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        for (SearchQueryEvaluator query : queries) {
            boolean hasResult;
            Collection<BindingSet> bindingSets = this.luceneIndex.evaluate(query);
            boolean bl = hasResult = bindingSets != null && !bindingSets.isEmpty();
            if (hasResult) {
                BindingSetAssignment bsa = new BindingSetAssignment();
                bsa.setBindingSets(bindingSets);
                if (bindingSets instanceof BindingSetCollection) {
                    bsa.setBindingNames(((BindingSetCollection)bindingSets).getBindingNames());
                }
                this.addBindingSets(query, bsa);
            }
            query.updateQueryModelNodes(hasResult);
        }
    }

    private void addBindingSets(SearchQueryEvaluator query, BindingSetAssignment bindingSets) {
        QueryModelNode principalNode = query.getParentQueryModelNode();
        final Projection projection = (Projection)this.getParentNodeOfType(principalNode, Projection.class);
        if (projection == null) {
            this.logger.error("Could not add bindings to the query tree because no projection was found for the query node: {}", (Object)principalNode);
            return;
        }
        final ArrayList assignments = new ArrayList();
        AbstractQueryModelVisitor<RuntimeException> assignmentVisitor = new AbstractQueryModelVisitor<RuntimeException>(){

            public void meet(BindingSetAssignment node) throws RuntimeException {
                QueryModelNode parent = LuceneSailConnection.this.getParentNodeOfType((QueryModelNode)node, Projection.class);
                if (parent != null && parent.equals((Object)projection)) {
                    assignments.add(node);
                }
            }
        };
        projection.visit((QueryModelVisitor)assignmentVisitor);
        ArrayList<BindingSetAssignment> bindingSetsList = new ArrayList<BindingSetAssignment>();
        bindingSetsList.add(bindingSets);
        for (BindingSetAssignment assignment : assignments) {
            bindingSetsList.add(assignment);
            assignment.replaceWith((QueryModelNode)new SingletonSet());
        }
        BindingSetAssignment bindings = this.joinBindingSets(bindingSetsList.iterator());
        TupleExpr arg = projection.getArg();
        if (arg instanceof LeftJoin) {
            LeftJoin binary = (LeftJoin)arg;
            Join join = new Join((TupleExpr)bindings, binary.getLeftArg());
            binary.setLeftArg((TupleExpr)join);
        } else {
            Join join = new Join((TupleExpr)bindings, arg);
            projection.setArg((TupleExpr)join);
        }
    }

    private QueryModelNode getParentNodeOfType(QueryModelNode node, Class<? extends QueryModelNode> type) {
        QueryModelNode parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        if (parent.getClass().equals(type)) {
            return parent;
        }
        return this.getParentNodeOfType(parent, type);
    }

    private BindingSetAssignment joinBindingSets(Iterator<BindingSetAssignment> iterator) {
        if (iterator.hasNext()) {
            BindingSetAssignment left = iterator.next();
            BindingSetAssignment right = this.joinBindingSets(iterator);
            if (right != null) {
                return this.crossJoin(left, right);
            }
            return left;
        }
        return null;
    }

    private BindingSetAssignment crossJoin(BindingSetAssignment left, BindingSetAssignment right) {
        Iterable leftIter = left.getBindingSets();
        Iterable rightIter = right.getBindingSets();
        int leftSize = LuceneSailConnection.size(leftIter, 16);
        int rightSize = LuceneSailConnection.size(rightIter, 16);
        ArrayList<QueryBindingSet> output = new ArrayList<QueryBindingSet>(leftSize * rightSize);
        for (BindingSet l : leftIter) {
            for (BindingSet r : rightIter) {
                QueryBindingSet bs = new QueryBindingSet();
                bs.addAll(l);
                bs.addAll(r);
                output.add(bs);
            }
        }
        HashSet bindingNames = new HashSet(left.getBindingNames());
        bindingNames.addAll(right.getBindingNames());
        BindingSetAssignment bindings = new BindingSetAssignment();
        bindings.setBindingSets(output);
        bindings.setBindingNames(bindingNames);
        return bindings;
    }

    private static int size(Iterable<?> iter, int defaultSize) {
        return iter instanceof Collection ? ((Collection)iter).size() : defaultSize;
    }

    public synchronized void removeStatements(Resource arg0, IRI arg1, Value arg2, Resource ... arg3) throws SailException {
        super.removeStatements(arg0, arg1, arg2, arg3);
    }

    public void rollback() throws SailException {
        super.rollback();
        this.buffer.reset();
        try {
            this.luceneIndex.rollback();
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }
}

