/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailTripleSource
implements TripleSource {
    private final SailConnection conn;
    private final boolean includeInferred;
    private final ValueFactory vf;

    public SailTripleSource(SailConnection conn, boolean includeInferred, ValueFactory valueFactory) {
        this.conn = conn;
        this.includeInferred = includeInferred;
        this.vf = valueFactory;
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        try {
            CloseableIteration iter = this.conn.getStatements(subj, pred, obj, this.includeInferred, contexts);
            return new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)iter){

                protected QueryEvaluationException convert(Exception e) {
                    return new QueryEvaluationException((Throwable)e);
                }
            };
        }
        catch (SailException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }
}

