/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.readonly.sparql;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.http.server.readonly.sparql.EvaluateResult;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

enum QueryTypes {
    CONSTRUCT_OR_DESCRIBE(q -> q instanceof GraphQuery, new FileFormat[]{RDFFormat.TURTLE, RDFFormat.NTRIPLES, RDFFormat.JSONLD, RDFFormat.RDFXML}){

        @Override
        protected void evaluate(EvaluateResult result, Query q, String acceptHeader) throws QueryEvaluationException, RDFHandlerException, UnsupportedRDFormatException, IOException {
            GraphQuery gq = (GraphQuery)q;
            RDFFormat format = (RDFFormat)this.bestFormat(acceptHeader);
            result.setContentType(format.getDefaultMIMEType());
            gq.evaluate((RDFHandler)Rio.createWriter((RDFFormat)format, (OutputStream)result.getOutputstream()));
        }
    }
    ,
    SELECT(q -> q instanceof TupleQuery, new FileFormat[]{TupleQueryResultFormat.JSON, TupleQueryResultFormat.SPARQL, TupleQueryResultFormat.CSV, TupleQueryResultFormat.TSV}){

        @Override
        protected void evaluate(EvaluateResult result, Query q, String acceptHeader) throws QueryEvaluationException, RDFHandlerException, UnsupportedRDFormatException, IOException {
            TupleQuery tq = (TupleQuery)q;
            QueryResultFormat format = (QueryResultFormat)this.bestFormat(acceptHeader);
            result.setContentType(format.getDefaultMIMEType());
            tq.evaluate((TupleQueryResultHandler)QueryResultIO.createTupleWriter((QueryResultFormat)format, (OutputStream)result.getOutputstream()));
        }
    }
    ,
    ASK(q -> q instanceof BooleanQuery, new FileFormat[]{BooleanQueryResultFormat.TEXT, BooleanQueryResultFormat.JSON, BooleanQueryResultFormat.SPARQL}){

        @Override
        protected void evaluate(EvaluateResult result, Query q, String acceptHeader) throws QueryEvaluationException, RDFHandlerException, UnsupportedRDFormatException, IOException {
            BooleanQuery bq = (BooleanQuery)q;
            QueryResultFormat format = (QueryResultFormat)this.bestFormat(acceptHeader);
            result.setContentType(format.getDefaultMIMEType());
            Optional optional = BooleanQueryResultWriterRegistry.getInstance().get((Object)format);
            if (optional.isPresent()) {
                BooleanQueryResultWriter writer = ((BooleanQueryResultWriterFactory)optional.get()).getWriter(result.getOutputstream());
                writer.handleBoolean(bq.evaluate());
            }
        }
    };

    private final FileFormat[] formats;
    private final Predicate<Query> typeChecker;

    private QueryTypes(Predicate<Query> typeChecker, FileFormat ... formats) {
        this.typeChecker = typeChecker;
        this.formats = formats;
    }

    public boolean accepts(Query preparedQuery, String acceptHeader) throws IllegalStateException {
        if (this.accepts(preparedQuery)) {
            if (acceptHeader == null || acceptHeader.isEmpty()) {
                return true;
            }
            for (FileFormat format : this.formats) {
                for (String mimeType : format.getMIMETypes()) {
                    if (!acceptHeader.contains(mimeType)) continue;
                    return true;
                }
            }
            throw new IllegalStateException("acceptHeader is mandatory.");
        }
        return false;
    }

    protected abstract void evaluate(EvaluateResult var1, Query var2, String var3) throws QueryEvaluationException, RDFHandlerException, UnsupportedRDFormatException, IOException;

    protected boolean accepts(Query q) {
        return this.typeChecker.test(q);
    }

    protected FileFormat bestFormat(String acceptHeader) {
        if (acceptHeader == null || acceptHeader.isEmpty()) {
            return this.formats[0];
        }
        for (FileFormat format : this.formats) {
            for (String mimeType : format.getMIMETypes()) {
                if (!acceptHeader.contains(mimeType)) continue;
                return format;
            }
        }
        return this.formats[0];
    }
}

