/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.readonly.sparql;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rdf4j.http.server.readonly.sparql.EvaluateResult;
import org.eclipse.rdf4j.http.server.readonly.sparql.QueryTypes;
import org.eclipse.rdf4j.http.server.readonly.sparql.SparqlQueryEvaluator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.springframework.stereotype.Component;

@Component
class SparqlQueryEvaluatorDefault
implements SparqlQueryEvaluator {
    SparqlQueryEvaluatorDefault() {
    }

    @Override
    public void evaluate(EvaluateResult result, Repository repository, String query, String acceptHeader, String defaultGraphUri, String[] namedGraphUris) throws MalformedQueryException, IOException, IllegalStateException {
        try (RepositoryConnection connection = repository.getConnection();){
            Query preparedQuery = connection.prepareQuery(QueryLanguage.SPARQL, query);
            preparedQuery.setDataset(this.getQueryDataSet(defaultGraphUri, namedGraphUris, connection));
            for (QueryTypes qt : QueryTypes.values()) {
                if (!qt.accepts(preparedQuery, acceptHeader)) continue;
                qt.evaluate(result, preparedQuery, acceptHeader);
            }
        }
    }

    private Dataset getQueryDataSet(String defaultGraphUri, String[] namedGraphUris, RepositoryConnection connection) {
        SimpleDataset dataset = new SimpleDataset();
        if (defaultGraphUri != null) {
            IRI defaultIri = connection.getValueFactory().createIRI(defaultGraphUri);
            dataset.addDefaultGraph(defaultIri);
        }
        Arrays.stream(namedGraphUris).forEach(namedGraphUri -> {
            IRI namedIri = connection.getValueFactory().createIRI(namedGraphUri);
            dataset.addNamedGraph(namedIri);
        });
        return dataset;
    }
}

