/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationlog.log.jmx;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.spring.operationlog.log.OperationExecutionStats;
import org.eclipse.rdf4j.spring.operationlog.log.OperationExecutionStatsConsumer;
import org.eclipse.rdf4j.spring.operationlog.log.jmx.AggregatedOperationStats;
import org.eclipse.rdf4j.spring.operationlog.log.jmx.OperationStatsMXBean;

public class OperationStatsBean
implements OperationStatsMXBean,
OperationExecutionStatsConsumer {
    private Map<String, AggregatedOperationStats> stats = new HashMap<String, AggregatedOperationStats>();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public List<AggregatedOperationStats> getAggregatedOperationStats() {
        return this.stats.values().stream().sorted((l, r) -> {
            int cmp = r.getCount() - l.getCount();
            if (cmp != 0) {
                return cmp;
            }
            return (int)(r.getCumulativeTime() - l.getCumulativeTime());
        }).collect(Collectors.toList());
    }

    @Override
    public int getDistinctOperationCount() {
        return this.stats.size();
    }

    @Override
    public int getDistinctOperationExecutionCount() {
        return this.stats.values().stream().mapToInt(AggregatedOperationStats::getUniqueBindingsCount).sum();
    }

    @Override
    public int getTotalOperationExecutionCount() {
        return this.stats.values().stream().mapToInt(AggregatedOperationStats::getCount).sum();
    }

    @Override
    public long getTotalOperationExecutionTime() {
        return this.stats.values().stream().mapToLong(AggregatedOperationStats::getCumulativeTime).sum();
    }

    @Override
    public int getTotalFailedOperationExecutionCount() {
        return this.stats.values().stream().mapToInt(AggregatedOperationStats::getFailed).sum();
    }

    @Override
    public void reset() {
        this.executorService.execute(() -> {
            Map<String, AggregatedOperationStats> old = this.stats;
            this.stats = new HashMap<String, AggregatedOperationStats>();
            old.clear();
        });
    }

    @Override
    public void consumeOperationExecutionStats(OperationExecutionStats operationExecutionStats) {
        this.executorService.execute(() -> {
            HashMap<String, AggregatedOperationStats> newStats = new HashMap<String, AggregatedOperationStats>(this.stats);
            AggregatedOperationStats aggregated = this.stats.get(operationExecutionStats.getOperation());
            aggregated = aggregated == null ? AggregatedOperationStats.build(operationExecutionStats) : aggregated.buildNext(operationExecutionStats);
            newStats.put(operationExecutionStats.getOperation(), aggregated);
            this.stats = newStats;
        });
    }
}

