/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.spring.dao.RDF4JDao;
import org.eclipse.rdf4j.spring.dao.exception.IncorrectResultSetSizeException;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.BindingsBuilder;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.MutableBindings;
import org.eclipse.rdf4j.spring.dao.support.key.CompositeKey;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.TupleQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.UpdateExecutionBuilder;
import org.eclipse.rdf4j.spring.dao.support.sparql.NamedSparqlSupplier;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;

public abstract class RDF4JCRUDDao<ENTITY, INPUT, ID>
extends RDF4JDao {
    private static final String KEY_READ_QUERY = "readQuery";
    public static final String KEY_PREFIX_INSERT = "insert";
    public static final String KEY_PREFIX_UPDATE = "update";
    private final Class<ID> idClass;

    public RDF4JCRUDDao(RDF4JTemplate rdf4JTemplate, Class<ID> idClass) {
        super(rdf4JTemplate);
        this.idClass = idClass;
    }

    public RDF4JCRUDDao(RDF4JTemplate rdf4JTemplate) {
        this(rdf4JTemplate, IRI.class);
    }

    public final ENTITY save(INPUT input) {
        ID id = this.getInputId(input);
        ID finalId = this.saveAndReturnId(input, id);
        return this.getById(finalId);
    }

    public ID saveAndReturnId(INPUT input) {
        return this.saveAndReturnId(input, this.getInputId(input));
    }

    public ID saveAndReturnId(INPUT input, ID id) {
        if (id != null) {
            this.deleteForUpdate(id);
        }
        ID finalId = this.getOrGenerateId(id);
        ((UpdateExecutionBuilder)((UpdateExecutionBuilder)this.getInsertQueryOrUseCached(input).withBindings(bindingsBuilder -> this.populateIdBindings((MutableBindings)bindingsBuilder, finalId))).withBindings(bindingsBuilder -> this.populateBindingsForUpdate((MutableBindings)bindingsBuilder, input))).execute(bindings -> this.postProcessUpdate(input, (Map<String, Value>)bindings));
        return finalId;
    }

    protected void deleteForUpdate(ID id) {
        IRI iri = this.convertIdToIri(id);
        this.getRdf4JTemplate().deleteTriplesWithSubject(iri);
    }

    private ID getOrGenerateId(ID id) {
        boolean idPresent;
        if (id instanceof CompositeKey) {
            idPresent = ((CompositeKey)id).isPresent();
        } else {
            boolean bl = idPresent = id != null;
        }
        if (!idPresent) {
            id = this.generateNewId(id);
        }
        return id;
    }

    protected IRI convertIdToIri(ID id) {
        if (id == null) {
            return null;
        }
        if (this.idClass.equals(IRI.class)) {
            return (IRI)id;
        }
        throw new UnsupportedOperationException("Cannot generically convert IDs to IRIs. The subclass must implement convertToIri(ID)");
    }

    protected ID generateNewId(ID providedId) {
        if (this.idClass.equals(IRI.class)) {
            return (ID)this.getRdf4JTemplate().getNewUUID();
        }
        throw new UnsupportedOperationException("Cannot generically generate any other IDs than IRIs. The subclass must implement generateNewId(ID)");
    }

    private UpdateExecutionBuilder getInsertQueryOrUseCached(INPUT input) {
        NamedSparqlSupplier cs = this.getInsertSparql(input);
        String key = KEY_PREFIX_INSERT + cs.getName();
        return this.getRdf4JTemplate().update(this.getClass(), key, cs.getSparqlSupplier());
    }

    public final List<ENTITY> list() {
        return this.getReadQueryOrUseCached().evaluateAndConvert().toList(this::mapSolution, this::postProcessMappedSolution);
    }

    private TupleQueryEvaluationBuilder getReadQueryOrUseCached() {
        return this.getRdf4JTemplate().tupleQuery(this.getClass(), KEY_READ_QUERY, this::getReadQuery);
    }

    public final ENTITY getById(ID id) {
        return this.getByIdOptional(id).orElseThrow(() -> new IncorrectResultSetSizeException("Expected to find exactly one entity but found 0", 1, 0));
    }

    public final Optional<ENTITY> getByIdOptional(ID id) {
        return ((TupleQueryEvaluationBuilder)this.getReadQueryOrUseCached().withBindings(bindingsBuilder -> this.populateIdBindings((MutableBindings)bindingsBuilder, id))).evaluateAndConvert().toSingletonOptional(this::mapSolution, this::postProcessMappedSolution);
    }

    public void delete(ID id) {
        if (!this.idClass.equals(IRI.class)) {
            throw new UnsupportedOperationException("Cannot generically delete instances that do not use IRI ids. The subclass must implement delete(ID)");
        }
        this.getRdf4JTemplate().delete((IRI)id);
    }

    protected String getReadQuery() {
        throw new UnsupportedOperationException("Cannot perform generic read operation: subclass does not override getReadQuery()");
    }

    protected ENTITY mapSolution(BindingSet querySolution) {
        throw new UnsupportedOperationException("Cannot perform generic read operation: subclass does not override mapSolution()");
    }

    protected ENTITY postProcessMappedSolution(ENTITY entity) {
        return entity;
    }

    protected void postProcessUpdate(INPUT input, Map<String, Value> bindings) {
    }

    protected NamedSparqlSupplier getInsertSparql(INPUT input) {
        throw new UnsupportedOperationException("Cannot perform generic write operation: subclass does not override getInsertQuery()");
    }

    protected NamedSparqlSupplier getUpdateSparql(INPUT input) {
        throw new UnsupportedOperationException("Cannot perform generic write operation: subclass does not override getUpdateQuery()");
    }

    protected abstract void populateIdBindings(MutableBindings var1, ID var2);

    protected void populateBindingsForUpdate(MutableBindings bindingsBuilder, INPUT input) {
        throw new UnsupportedOperationException("Cannot perform generic write operation: subclass does not override populateBindingsForUpdate()");
    }

    protected ID getInputId(INPUT input) {
        throw new UnsupportedOperationException("Cannot perform generic write operation: subclass does not override getInputId()");
    }

    protected static BindingsBuilder newBindingsBuilder() {
        return new BindingsBuilder();
    }
}

