/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.operation;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.spring.dao.exception.mapper.ExceptionMapper;
import org.eclipse.rdf4j.spring.dao.support.BindingSetMapper;
import org.eclipse.rdf4j.spring.dao.support.MappingPostProcessor;
import org.eclipse.rdf4j.spring.dao.support.TupleQueryResultMapper;
import org.eclipse.rdf4j.spring.dao.support.operation.OperationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleQueryResultConverter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TupleQueryResult tupleQueryResult;

    public TupleQueryResultConverter(TupleQueryResult result) {
        Objects.requireNonNull(result);
        this.tupleQueryResult = result;
    }

    public void consumeResult(Consumer<TupleQueryResult> consumer) {
        try {
            consumer.accept(this.tupleQueryResult);
        }
        catch (Exception e) {
            logger.debug("Caught execption while processing TupleQueryResult", (Throwable)e);
            throw ExceptionMapper.mapException("Error processing TupleQueryResult", e);
        }
        finally {
            this.tupleQueryResult.close();
            this.tupleQueryResult = null;
        }
    }

    public <T> T applyToResult(Function<TupleQueryResult, T> function) {
        try {
            T t = function.apply(this.tupleQueryResult);
            return t;
        }
        catch (Exception e) {
            logger.warn("Caught execption while processing TupleQueryResult", (Throwable)e);
            throw ExceptionMapper.mapException("Error processing TupleQueryResult", e);
        }
        finally {
            this.tupleQueryResult.close();
            this.tupleQueryResult = null;
        }
    }

    public Stream<BindingSet> toStream() {
        return this.applyToResult(r -> this.getBindingStream((TupleQueryResult)r).collect(Collectors.toList()).stream());
    }

    private <T> Stream<T> toStreamInternal(Function<BindingSet, T> mapper) {
        return this.applyToResult(result -> this.getBindingStream((TupleQueryResult)result).map(mapper).filter(Objects::nonNull).collect(Collectors.toList()).stream());
    }

    public <T> Stream<T> toStream(BindingSetMapper<T> mapper) {
        return this.toStreamInternal(mapper);
    }

    public <T, O> Stream<O> toStream(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return this.toStreamInternal(this.andThenOrElseNull(mapper, postProcessor));
    }

    public <T> T toSingletonMaybeOfWholeResult(TupleQueryResultMapper<T> mapper) {
        return this.applyToResult(mapper);
    }

    public <T> Optional<T> toSingletonOptionalOfWholeResult(TupleQueryResultMapper<T> mapper) {
        return Optional.ofNullable(this.toSingletonMaybeOfWholeResult(mapper));
    }

    public <T> T toSingletonOfWholeResult(TupleQueryResultMapper<T> mapper) {
        return OperationUtils.require(this.toSingletonOptionalOfWholeResult(mapper));
    }

    public <T> T toSingletonMaybe(BindingSetMapper<T> mapper) {
        return this.mapAndCollect(mapper, OperationUtils.toSingletonMaybe());
    }

    public <T> Optional<T> toSingletonOptional(BindingSetMapper<T> mapper) {
        return Optional.ofNullable(this.toSingletonMaybe(mapper));
    }

    public <T> T toSingleton(BindingSetMapper<T> mapper) {
        return OperationUtils.require(this.toSingletonOptional(mapper));
    }

    public <T, O> O toSingletonMaybe(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return (O)this.mapAndCollect(this.andThenOrElseNull(mapper, postProcessor), OperationUtils.toSingletonMaybe());
    }

    public <T, O> Optional<O> toSingletonOptional(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return Optional.ofNullable(this.toSingletonMaybe(mapper, postProcessor));
    }

    public <T, O> O toSingleton(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return OperationUtils.require(this.toSingletonOptional(mapper, postProcessor));
    }

    public <T, A, R> R mapAndCollect(Function<BindingSet, T> mapper, Collector<T, A, R> collector) {
        return (R)this.applyToResult(result -> this.getBindingStream((TupleQueryResult)result).map(mapper).filter(Objects::nonNull).collect(collector));
    }

    public <T> List<T> toList(BindingSetMapper<T> mapper) {
        return this.mapAndCollect(mapper, Collectors.toList());
    }

    public <T, O> List<O> toList(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return this.mapAndCollect(this.andThenOrElseNull(mapper, postProcessor), Collectors.toList());
    }

    public <T> Set<T> toSet(BindingSetMapper<T> mapper) {
        return this.mapAndCollect(mapper, Collectors.toSet());
    }

    public <T, O> Set<O> toSet(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return this.mapAndCollect(this.andThenOrElseNull(mapper, postProcessor), Collectors.toSet());
    }

    public <K, V> Map<K, V> toMap(Function<BindingSet, K> keyMapper, Function<BindingSet, V> valueMapper) {
        return this.mapAndCollect(Function.identity(), Collectors.toMap(keyMapper, valueMapper));
    }

    public <K, V> Map<K, Set<V>> toMapOfSet(Function<BindingSet, K> keyMapper, Function<BindingSet, V> valueMapper) {
        return this.mapAndCollect(Function.identity(), Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, Collectors.toSet())));
    }

    public <K, V> Map<K, List<V>> toMapOfList(Function<BindingSet, K> keyMapper, Function<BindingSet, V> valueMapper) {
        return this.mapAndCollect(Function.identity(), Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, Collectors.toList())));
    }

    public <T, K, V> Map<K, V> toMap(BindingSetMapper<T> mapper, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return this.mapAndCollect(mapper, Collectors.toMap(keyMapper, valueMapper));
    }

    public <K, V> Map<K, V> toMap(Function<BindingSet, Map.Entry<K, V>> entryMapper) {
        return this.mapAndCollect(Function.identity(), Collectors.toMap(bs -> ((Map.Entry)entryMapper.apply((BindingSet)bs)).getKey(), bs -> ((Map.Entry)entryMapper.apply((BindingSet)bs)).getValue()));
    }

    public <T, K, V> Map<K, Set<V>> toMapOfSet(BindingSetMapper<T> mapper, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return this.mapAndCollect(mapper, Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, Collectors.toSet())));
    }

    public <T, K, V> Map<K, List<V>> toMapOfList(BindingSetMapper<T> mapper, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return this.mapAndCollect(mapper, Collectors.groupingBy(keyMapper, Collectors.mapping(valueMapper, Collectors.toList())));
    }

    public Stream<BindingSet> getBindingStream(TupleQueryResult result) {
        if (!result.hasNext()) {
            return Stream.empty();
        }
        BindingSet first = (BindingSet)result.next();
        if (!result.hasNext() && first.size() == 0) {
            return Stream.empty();
        }
        return Stream.concat(Stream.of(first), result.stream());
    }

    private <T, O> Function<BindingSet, O> andThenOrElseNull(BindingSetMapper<T> mapper, MappingPostProcessor<T, O> postProcessor) {
        return bindingSet -> Optional.ofNullable(mapper.apply((BindingSet)bindingSet)).map(postProcessor).orElse(null);
    }
}

