/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationlog.log;

import java.util.Arrays;
import java.util.stream.Collectors;

public class PseudoOperation {
    private final String operation;
    private final int valuesHash;

    private PseudoOperation(String operation, int valuesHash) {
        this.operation = operation;
        this.valuesHash = valuesHash;
    }

    public static PseudoOperation forGetSatements(Object ... args) {
        return PseudoOperation.forMethodNameAndArgs("getStatements", args);
    }

    public static PseudoOperation forAdd(Object ... args) {
        String argsString = PseudoOperation.getArgsString(args);
        return PseudoOperation.forMethodNameAndArgs("add", args);
    }

    public static PseudoOperation forRemove(Object ... args) {
        return PseudoOperation.forMethodNameAndArgs("remove", args);
    }

    public static PseudoOperation forClear(Object ... args) {
        String argsString = PseudoOperation.getArgsString(args);
        return PseudoOperation.forMethodNameAndArgs("clear", args);
    }

    public static PseudoOperation forHasStatement(Object ... args) {
        return PseudoOperation.forMethodNameAndArgs("hasStatement", args);
    }

    public static PseudoOperation forMethodNameAndArgs(String methodName, Object ... args) {
        String argsString = PseudoOperation.getArgsString(args);
        return new PseudoOperation("RepositoryConnection." + methodName + "(" + argsString + ")", Arrays.hashCode(args));
    }

    public static PseudoOperation forSize(Object ... args) {
        return PseudoOperation.forMethodNameAndArgs("size", args);
    }

    public String getOperation() {
        return this.operation;
    }

    public int getValuesHash() {
        return this.valuesHash;
    }

    private static String getArgsString(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        return Arrays.stream(args).map(o -> o == null ? "[null]" : o.getClass().getSimpleName()).collect(Collectors.joining(", "));
    }
}

