/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.repository.remote;

import java.lang.invoke.MethodHandles;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.spring.repository.remote.RemoteRepositoryProperties;
import org.eclipse.rdf4j.spring.support.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RemoteRepositoryProperties.class})
@ConditionalOnProperty(value={"rdf4j.spring.repository.remote.manager-url"})
public class RemoteRepositoryConfig {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Bean
    public Repository getRemoteRepository(@Autowired RemoteRepositoryProperties repositoryProperties) {
        logger.info("Using these repository properties: {}", (Object)repositoryProperties);
        try {
            RemoteRepositoryManager repositoryManager = new RemoteRepositoryManager(repositoryProperties.getManagerUrl());
            repositoryManager.init();
            Repository repository = repositoryManager.getRepository(repositoryProperties.getName());
            logger.debug("Successfully initialized repository config: {}", (Object)repositoryProperties);
            return repository;
        }
        catch (Exception e) {
            throw new ConfigurationException(String.format("Unable to retrieve repository for repository config %s", repositoryProperties), e);
        }
    }
}

