/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.uuidsource.sequence;

import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.eclipse.rdf4j.spring.support.UUIDSource;
import org.eclipse.rdf4j.spring.util.QueryResultUtils;
import org.eclipse.rdf4j.spring.uuidsource.sequence.UUIDSequenceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UUIDSequence
implements UUIDSource {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private RDF4JTemplate rdf4JTemplate;
    private final int prefetchCount;
    private final Map<RepositoryConnection, Queue<IRI>> prefetchedUUIDs = Collections.synchronizedMap(new WeakHashMap());

    public UUIDSequence(UUIDSequenceProperties properties) {
        this.prefetchCount = properties.getPrefetchCount();
        logger.debug("UUIDSequence uses prefetchCount of {}", (Object)this.prefetchCount);
    }

    @Override
    public IRI nextUUID() {
        if (logger.isDebugEnabled()) {
            logger.debug("Obtaining UUID from UUIDSequence...");
        }
        return this.rdf4JTemplate.applyToConnection(con -> {
            Queue<IRI> uuids = this.prefetchedUUIDs.computeIfAbsent((RepositoryConnection)con, this::prefetchUUIDs);
            IRI uuid = (IRI)uuids.poll();
            if (uuid == null) {
                uuids = this.prefetchUUIDs((RepositoryConnection)con);
                this.prefetchedUUIDs.put((RepositoryConnection)con, uuids);
                uuid = uuids.poll();
            }
            if (uuid == null) {
                throw new IllegalStateException("Unable to produce next UUID in sequence");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Returning next UUID");
            }
            return uuid;
        });
    }

    private Queue<IRI> prefetchUUIDs(RepositoryConnection con) {
        double nd = Math.pow(this.prefetchCount, 0.3333333333333333);
        int n = (int)Math.ceil(nd);
        int exactPrefetchCount = (int)Math.ceil(Math.pow(n, 3.0));
        if (logger.isDebugEnabled()) {
            logger.debug("prefetching {} uuids from the repostory", (Object)exactPrefetchCount);
        }
        String ints = IntStream.range(0, n).mapToObj(Integer::toString).collect(Collectors.joining(" "));
        TupleQuery query = con.prepareTupleQuery("SELECT (UUID() as ?id) WHERE {VALUES ?index1 { " + ints + " } VALUES ?index2 { " + ints + " } VALUES ?index3 { " + ints + " } }");
        ArrayDeque<IRI> uuids = new ArrayDeque<IRI>(exactPrefetchCount);
        try (TupleQueryResult result = query.evaluate();){
            while (result.hasNext()) {
                BindingSet b = (BindingSet)result.next();
                uuids.add(QueryResultUtils.getIRI(b, "id"));
            }
        }
        return uuids;
    }
}

