/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.spring.resultcache.CachedTupleQueryResult;
import org.eclipse.rdf4j.spring.resultcache.ThrowableRecorder;
import org.eclipse.rdf4j.spring.support.query.DelegatingIterator;

public class ReusableTupleQueryResult
implements TupleQueryResult,
ThrowableRecorder {
    private TupleQueryResult originalResult;
    private final List<BindingSet> bindingSets;
    private final AtomicBoolean recording = new AtomicBoolean(true);
    private final AtomicBoolean exceptionDuringRecording = new AtomicBoolean(false);
    private final BindingSet queryBindings;
    private List<String> bindingNames;

    public ReusableTupleQueryResult(TupleQueryResult result, BindingSet queryBindings) {
        this.originalResult = result;
        this.queryBindings = queryBindings;
        this.bindingSets = new LinkedList<BindingSet>();
        this.recording.set(true);
        this.exceptionDuringRecording.set(false);
    }

    public boolean queryBindingsAreIdentical(BindingSet candidate) {
        return this.queryBindings.equals((Object)candidate);
    }

    public boolean canReuse() {
        return !this.recording.get() && this.originalResult == null && !this.exceptionDuringRecording.get();
    }

    public CachedTupleQueryResult recreateTupleQueryResult() {
        if (this.recording.get()) {
            throw new IllegalStateException("Cannot reuse yet: still recording");
        }
        return new CachedTupleQueryResult(this.bindingSets, this.bindingNames);
    }

    @Override
    public void recordThrowable(Throwable t) {
        if (this.recording.get()) {
            this.exceptionDuringRecording.set(true);
        }
    }

    public List<String> getBindingNames() throws QueryEvaluationException {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> ((TupleQueryResult)this.originalResult).getBindingNames(), (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public Iterator<BindingSet> iterator() {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> new DelegatingIterator<BindingSet>(this.originalResult.iterator()){

                @Override
                public BindingSet next() {
                    BindingSet n = (BindingSet)super.next();
                    ReusableTupleQueryResult.this.bindingSets.add(n);
                    return n;
                }
            }, (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public void close() throws QueryEvaluationException {
        if (!this.recording.get()) {
            throw new IllegalStateException("Cannot close: not open");
        }
        ThrowableRecorder.recordingThrowable(() -> {
            while (this.hasNext()) {
                this.next();
            }
            try {
                this.bindingNames = this.originalResult.getBindingNames();
                this.originalResult.close();
            }
            finally {
                this.originalResult = null;
                this.recording.set(false);
            }
        }, (ThrowableRecorder)this);
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> this.originalResult.hasNext(), (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public BindingSet next() throws QueryEvaluationException {
        if (this.recording.get()) {
            BindingSet n = ThrowableRecorder.recordingThrowable(() -> (BindingSet)this.originalResult.next(), (ThrowableRecorder)this);
            this.bindingSets.add(n);
            return n;
        }
        throw new IllegalStateException("Not open");
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public Stream<BindingSet> stream() {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> this.originalResult.stream().map(bindings -> {
                this.bindingSets.add((BindingSet)bindings);
                return bindings;
            }), (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public void forEach(Consumer<? super BindingSet> action) {
        if (!this.recording.get()) {
            throw new IllegalStateException("Not open");
        }
        ThrowableRecorder.recordingThrowable(() -> this.originalResult.forEach(bindings -> {
            this.bindingSets.add((BindingSet)bindings);
            action.accept((BindingSet)bindings);
        }), (ThrowableRecorder)this);
    }

    public Spliterator<BindingSet> spliterator() {
        if (this.recording.get()) {
            return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
        }
        throw new IllegalStateException("Not open");
    }
}

