/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.tx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.spring.tx.TransactionObject;
import org.eclipse.rdf4j.spring.tx.exception.WriteDeniedException;

public class TransactionalRepositoryConnection
extends RepositoryConnectionWrapper {
    TransactionObject transactionObject;

    public TransactionalRepositoryConnection(Repository repository) {
        super(repository);
        this.transactionObject = null;
    }

    public TransactionalRepositoryConnection(Repository repository, RepositoryConnection delegate) {
        super(repository, delegate);
        this.transactionObject = this.transactionObject = null;
    }

    public void setTransactionObject(TransactionObject transactionObject) {
        this.transactionObject = transactionObject;
    }

    private void throwExceptionIfReadonly() {
        if (this.transactionObject.isReadOnly()) {
            throw new WriteDeniedException("Cannot write in a read-only transaction!");
        }
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(file, baseURI, dataFormat, contexts);
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(in, baseURI, dataFormat, contexts);
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(statements, contexts);
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        this.throwExceptionIfReadonly();
        super.add(statementIter, contexts);
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(reader, baseURI, dataFormat, contexts);
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(subject, predicate, object, contexts);
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(st, contexts);
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(url, baseURI, dataFormat, contexts);
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.clear(contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.remove(statements, contexts);
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        this.throwExceptionIfReadonly();
        super.remove(statementIter, contexts);
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.remove(subject, predicate, object, contexts);
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.remove(st, contexts);
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.removeNamespace(prefix);
    }

    public void clearNamespaces() throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.clearNamespaces();
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.setNamespace(prefix, name);
    }

    public Update prepareUpdate(String update) throws RepositoryException, MalformedQueryException {
        this.throwExceptionIfReadonly();
        return super.prepareUpdate(update);
    }

    public void add(InputStream in, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(in, dataFormat, contexts);
    }

    public void add(Reader reader, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(reader, dataFormat, contexts);
    }

    public void add(URL url, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(url, contexts);
    }

    public void add(URL url, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(url, dataFormat, contexts);
    }

    public void add(File file, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(file, contexts);
    }

    public void add(File file, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(file, dataFormat, contexts);
    }

    public void add(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.add(statements, contexts);
    }

    public void remove(RepositoryResult<Statement> statements, Resource ... contexts) throws RepositoryException {
        this.throwExceptionIfReadonly();
        super.remove(statements, contexts);
    }
}

