/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class CascadeValueExceptionTest {
    private static String queryStrLT = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" < \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrLE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" <= \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrEQ = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" = \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrNE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" != \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrGE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" >= \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrGT = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\" > \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltLT = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> < \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltLE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> <= \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltEQ = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> = \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltNE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> != \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltGE = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> >= \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private static String queryStrAltGT = "SELECT * WHERE { ?s ?p ?o FILTER( !(\"2002\"^^<http://www.w3.org/2001/XMLSchema#string> > \"2007\"^^<http://www.w3.org/2001/XMLSchema#gYear>))}";
    private RepositoryConnection conn;
    private Repository repository;

    @Test
    public void testValueExceptionLessThanPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrLT);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionLessThanOrEqualPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrLE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionEqualPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrEQ);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionNotEqualPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrNE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionGreaterThanOrEqualPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrGE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionGreaterThanPlain() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrGT);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionLessThanTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltLT);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionLessThanOrEqualTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltLE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionEqualTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltEQ);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionNotEqualTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltNE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionGreaterThanOrEqualTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltGE);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testValueExceptionGreaterThanTyped() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStrAltGT);
        try (TupleQueryResult evaluate = query.evaluate();){
            Assert.assertFalse((boolean)evaluate.hasNext());
        }
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.conn = this.repository.getConnection();
        this.conn.add((Resource)RDF.NIL, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }
}

