/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class EquivalentTest {
    private static ValueFactory vf = SimpleValueFactory.getInstance();
    private static Literal xyz_simple = vf.createLiteral("xyz");
    private static Literal xyz_en = vf.createLiteral("xyz", "en");
    private static Literal xyz_EN = vf.createLiteral("xyz", "EN");
    private static Literal xyz_string = vf.createLiteral("xyz", XMLSchema.STRING);
    private static Literal xyz_integer = vf.createLiteral("xyz", XMLSchema.INTEGER);
    private static Literal xyz_unknown = vf.createLiteral("xyz", vf.createIRI("http://example/unknown"));
    private static IRI xyz_uri = vf.createIRI("http://example/xyz");
    private static Literal abc_simple = vf.createLiteral("abc");
    private static Literal abc_en = vf.createLiteral("abc", "en");
    private static Literal abc_EN = vf.createLiteral("abc", "EN");
    private static Literal abc_string = vf.createLiteral("abc", XMLSchema.STRING);
    private static Literal abc_integer = vf.createLiteral("abc", XMLSchema.INTEGER);
    private static Literal abc_unknown = vf.createLiteral("abc", vf.createIRI("http://example/unknown"));
    private static IRI abc_uri = vf.createIRI("http://example/abc");
    private static IRI t1 = vf.createIRI("http://example/t1");
    private static IRI t2 = vf.createIRI("http://example/t2");
    private static final String IND = "?";
    private static final String EQ = "=";
    private static final String NEQ = "!=";
    private static final String PREFIX = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX ex:<http://example/>";
    private static String matrix = "\"xyz\"\t\"xyz\"\teq\n\"xyz\"\t\"xyz\"@en\tneq\n\"xyz\"\t\"xyz\"@EN\tneq\n\"xyz\"\t\"xyz\"^^xsd:string\teq\n\"xyz\"\t\"xyz\"^^xsd:integer\tind\n\"xyz\"\t\"xyz\"^^ex:unknown\tind\n\"xyz\"\t_:xyz\tneq\n\"xyz\"\t:xyz\tneq\n\"xyz\"@en\t\"xyz\"\tneq\n\"xyz\"@en\t\"xyz\"@en\teq\n\"xyz\"@en\t\"xyz\"@EN\teq\n\"xyz\"@en\t\"xyz\"^^xsd:string\tneq\n\"xyz\"@en\t\"xyz\"^^xsd:integer\tneq\n\"xyz\"@en\t\"xyz\"^^ex:unknown\tneq\n\"xyz\"@en\t_:xyz\tneq\n\"xyz\"@en\t:xyz\tneq\n\"xyz\"@EN\t\"xyz\"\tneq\n\"xyz\"@EN\t\"xyz\"@en\teq\n\"xyz\"@EN\t\"xyz\"@EN\teq\n\"xyz\"@EN\t\"xyz\"^^xsd:string\tneq\n\"xyz\"@EN\t\"xyz\"^^xsd:integer\tneq\n\"xyz\"@EN\t\"xyz\"^^ex:unknown\tneq\n\"xyz\"@EN\t_:xyz\tneq\n\"xyz\"@EN\t:xyz\tneq\n\"xyz\"^^xsd:string\t\"xyz\"\teq\n\"xyz\"^^xsd:string\t\"xyz\"@en\tneq\n\"xyz\"^^xsd:string\t\"xyz\"@EN\tneq\n\"xyz\"^^xsd:string\t\"xyz\"^^xsd:string\teq\n\"xyz\"^^xsd:string\t\"xyz\"^^xsd:integer\tind\n\"xyz\"^^xsd:string\t\"xyz\"^^ex:unknown\tind\n\"xyz\"^^xsd:string\t_:xyz\tneq\n\"xyz\"^^xsd:string\t:xyz\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"\tind\n\"xyz\"^^xsd:integer\t\"xyz\"@en\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"@EN\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"^^xsd:string\tind\n\"xyz\"^^xsd:integer\t\"xyz\"^^xsd:integer\teq\n\"xyz\"^^xsd:integer\t\"xyz\"^^ex:unknown\tind\n\"xyz\"^^xsd:integer\t_:xyz\tneq\n\"xyz\"^^xsd:integer\t:xyz\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"\tind\n\"xyz\"^^ex:unknown\t\"xyz\"@en\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"@EN\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"^^xsd:string\tind\n\"xyz\"^^ex:unknown\t\"xyz\"^^xsd:integer\tind\n\"xyz\"^^ex:unknown\t\"xyz\"^^ex:unknown\teq\n\"xyz\"^^ex:unknown\t_:xyz\tneq\n\"xyz\"^^ex:unknown\t:xyz\tneq\n_:xyz\t\"xyz\"\tneq\n_:xyz\t\"xyz\"@en\tneq\n_:xyz\t\"xyz\"@EN\tneq\n_:xyz\t\"xyz\"^^xsd:string\tneq\n_:xyz\t\"xyz\"^^xsd:integer\tneq\n_:xyz\t\"xyz\"^^ex:unknown\tneq\n_:xyz\t_:xyz\teq\n_:xyz\t:xyz\tneq\n:xyz\t\"xyz\"\tneq\n:xyz\t\"xyz\"@en\tneq\n:xyz\t\"xyz\"@EN\tneq\n:xyz\t\"xyz\"^^xsd:string\tneq\n:xyz\t\"xyz\"^^xsd:integer\tneq\n:xyz\t\"xyz\"^^ex:unknown\tneq\n:xyz\t_:xyz\tneq\n:xyz\t:xyz\teq\n\"xyz\"\t\"abc\"\t\tneq\t\n\"xyz\"\t\"abc\"@en\t\tneq\t\n\"xyz\"\t\"abc\"@EN\t\tneq\t\n\"xyz\"\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"\t_:abc\t\tneq\t\n\"xyz\"\t:abc\t\tneq\t\n\"xyz\"@en\t\"abc\"\t\tneq\t\n\"xyz\"@en\t\"abc\"@en\t\tneq\t\n\"xyz\"@en\t\"abc\"@EN\t\tneq\t\n\"xyz\"@en\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"@en\t\"abc\"^^xsd:integer\t\tneq\t\n\"xyz\"@en\t\"abc\"^^:unknown\t\tneq\t\n\"xyz\"@en\t_:abc\t\tneq\t\n\"xyz\"@en\t:abc\t\tneq\t\n\"xyz\"@EN\t\"abc\"\t\tneq\t\n\"xyz\"@EN\t\"abc\"@en\t\tneq\t\n\"xyz\"@EN\t\"abc\"@EN\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^xsd:integer\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^:unknown\t\tneq\t\n\"xyz\"@EN\t_:abc\t\tneq\t\n\"xyz\"@EN\t:abc\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"@en\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^xsd:string\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^xsd:string\t_:abc\t\tneq\t\n\"xyz\"^^xsd:string\t:abc\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"@en\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"^^xsd:string\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^xsd:integer\t_:abc\t\tneq\t\n\"xyz\"^^xsd:integer\t:abc\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"@en\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"^^xsd:string\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^:unknown\t_:abc\t\tneq\t\n\"xyz\"^^:unknown\t:abc\t\tneq\t\n_:xyz\t\"abc\"\t\tneq\t\n_:xyz\t\"abc\"@en\t\tneq\t\n_:xyz\t\"abc\"@EN\t\tneq\t\n_:xyz\t\"abc\"^^xsd:string\t\tneq\t\n_:xyz\t\"abc\"^^xsd:integer\t\tneq\t\n_:xyz\t\"abc\"^^:unknown\t\tneq\t\n_:xyz\t_:abc\t\tneq\t\n_:xyz\t:abc\t\tneq\t\n:xyz\t\"abc\"\t\tneq\t\n:xyz\t\"abc\"@en\t\tneq\t\n:xyz\t\"abc\"@EN\t\tneq\t\n:xyz\t\"abc\"^^xsd:string\t\tneq\t\n:xyz\t\"abc\"^^xsd:integer\t\tneq\t\n:xyz\t\"abc\"^^:unknown\t\tneq\t\n:xyz\t_:abc\t\tneq\t\n:xyz\t:abc\t\tneq\t";
    private Value term1;
    private Value term2;
    private String operator;
    private Repository repository;

    @Parameterized.Parameters(name="{1} {0} {2}")
    public static Collection<Object[]> params() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        for (String row : matrix.split("\n")) {
            if (row.contains("_:")) continue;
            String[] fields = row.split("\t", 3);
            if (fields[2].contains("neq")) {
                params.add(new Object[]{NEQ, fields[0], fields[1]});
                continue;
            }
            if (fields[2].contains("eq")) {
                params.add(new Object[]{EQ, fields[0], fields[1]});
                continue;
            }
            if (fields[2].contains("ind")) {
                params.add(new Object[]{IND, fields[0], fields[1]});
                continue;
            }
            throw new AssertionError((Object)row);
        }
        return params;
    }

    public EquivalentTest(String operator, String term1, String term2) {
        this.operator = operator;
        this.term1 = EquivalentTest.getTerm(term1);
        this.term2 = EquivalentTest.getTerm(term2);
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        try (RepositoryConnection con = this.repository.getConnection();){
            con.begin();
            con.clear(new Resource[0]);
            con.add((Resource)t1, RDF.VALUE, this.term1, new Resource[0]);
            con.add((Resource)t2, RDF.VALUE, this.term2, new Resource[0]);
            con.commit();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.repository.shutDown();
        this.repository = null;
    }

    @Test
    public void testOperator() throws Throwable {
        Assert.assertEquals((Object)this.operator, (Object)this.compare(this.term1, this.term2));
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.begin();
            con.clear(new Resource[0]);
            con.clearNamespaces();
            con.commit();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    private static Value getTerm(String label) {
        if (label.contains("xyz")) {
            if (label.contains("integer")) {
                return xyz_integer;
            }
            if (label.contains("string")) {
                return xyz_string;
            }
            if (label.contains("unknown")) {
                return xyz_unknown;
            }
            if (label.contains("en")) {
                return xyz_en;
            }
            if (label.contains("EN")) {
                return xyz_EN;
            }
            if (label.contains(":xyz")) {
                return xyz_uri;
            }
            if (label.contains("\"xyz\"")) {
                return xyz_simple;
            }
        }
        if (label.contains("abc")) {
            if (label.contains("integer")) {
                return abc_integer;
            }
            if (label.contains("string")) {
                return abc_string;
            }
            if (label.contains("unknown")) {
                return abc_unknown;
            }
            if (label.contains("en")) {
                return abc_en;
            }
            if (label.contains("EN")) {
                return abc_EN;
            }
            if (label.contains(":abc")) {
                return abc_uri;
            }
            if (label.contains("\"abc\"")) {
                return abc_simple;
            }
        }
        throw new AssertionError((Object)label);
    }

    private String compare(Value term1, Value term2) throws Exception {
        boolean eq = this.evaluate(EQ);
        boolean neq = this.evaluate(NEQ);
        Assert.assertTrue((!eq || !neq ? 1 : 0) != 0);
        if (eq && !neq) {
            return EQ;
        }
        if (!eq && neq) {
            return NEQ;
        }
        if (!eq && !neq) {
            return IND;
        }
        throw new AssertionError();
    }

    private boolean evaluate(String op) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String qry = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX ex:<http://example/>SELECT ?term1 ?term2 WHERE {ex:t1 rdf:value ?term1 . ex:t2 rdf:value ?term2 FILTER (?term1 " + op + " ?term2)}";
        return this.evaluateSparql(qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateSparql(String qry) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        try (RepositoryConnection con = this.repository.getConnection();){
            boolean bl;
            con.begin();
            TupleQuery query = con.prepareTupleQuery(QueryLanguage.SPARQL, qry);
            TupleQueryResult evaluate = query.evaluate();
            try {
                bl = evaluate.hasNext();
            }
            catch (Throwable throwable) {
                evaluate.close();
                con.commit();
                throw throwable;
            }
            evaluate.close();
            con.commit();
            return bl;
        }
    }
}

