/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class GraphQueryResultTest {
    private Repository rep;
    private RepositoryConnection con;
    private String emptyDescribeQuery;
    private String singleDescribeQuery;
    private String multipleDescribeQuery;
    private String emptyConstructQuery;
    private String singleConstructQuery;
    private String multipleConstructQuery;

    @Before
    public void setUp() throws Exception {
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.buildQueries();
        this.addData();
    }

    @After
    public void tearDown() throws Exception {
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    private void buildQueries() {
        this.emptyDescribeQuery = "DESCRIBE <urn:test:non-existent-uri>";
        this.singleDescribeQuery = "DESCRIBE <" + OWL.THING.stringValue() + ">";
        this.multipleDescribeQuery = "DESCRIBE <" + OWL.CLASS.stringValue() + ">";
        this.emptyConstructQuery = "CONSTRUCT { <urn:test:non-existent-uri> ?p ?o . } WHERE { <urn:test:non-existent-uri> ?p ?o . }";
        this.singleConstructQuery = "CONSTRUCT { ?s ?p <" + OWL.THING.stringValue() + "> . } WHERE { ?s ?p <" + OWL.THING.stringValue() + "> . }";
        this.multipleConstructQuery = "CONSTRUCT { ?s ?p <" + OWL.CLASS.stringValue() + "> . } WHERE { ?s ?p <" + OWL.CLASS.stringValue() + "> . }";
    }

    private void addData() throws IOException, UnsupportedRDFormatException, RDFParseException, RepositoryException {
        try (InputStream defaultGraph = GraphQueryResultTest.class.getResourceAsStream("/testcases/graph3.ttl");){
            this.con.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
        }
    }

    @Test
    public void testDescribeEmpty() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.emptyDescribeQuery).evaluate();
        Assert.assertFalse((String)"Query result should be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertTrue((String)"Query result should be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testDescribeSingle() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.singleDescribeQuery).evaluate();
        Assert.assertTrue((String)"Query result should not be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertFalse((String)"Query result should not be empty", (boolean)model.isEmpty());
        Assert.assertEquals((long)1L, (long)model.size());
    }

    @Test
    public void testDescribeMultiple() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.multipleDescribeQuery).evaluate();
        Assert.assertTrue((String)"Query result should not be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertFalse((String)"Query result should not be empty", (boolean)model.isEmpty());
        Assert.assertEquals((long)4L, (long)model.size());
    }

    @Test
    public void testConstructEmpty() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.emptyConstructQuery).evaluate();
        Assert.assertFalse((String)"Query result should be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertTrue((String)"Query result should be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testConstructSingle() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.singleConstructQuery).evaluate();
        Assert.assertTrue((String)"Query result should not be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertFalse((String)"Query result should not be empty", (boolean)model.isEmpty());
        Assert.assertEquals((long)1L, (long)model.size());
    }

    @Test
    public void testConstructMultiple() throws Exception {
        GraphQueryResult result = this.con.prepareGraphQuery(QueryLanguage.SPARQL, this.multipleConstructQuery).evaluate();
        Assert.assertTrue((String)"Query result should not be empty", (boolean)result.hasNext());
        Model model = QueryResults.asModel((CloseableIteration)result);
        Assert.assertFalse((String)"Query result should not be empty", (boolean)model.isEmpty());
        Assert.assertEquals((long)4L, (long)model.size());
    }
}

