/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryConnectionTest;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class RDFSchemaRepositoryConnectionTest
extends RepositoryConnectionTest {
    private IRI person;
    private IRI woman;
    private IRI man;

    @Parameterized.Parameters(name="{0}")
    public static final IsolationLevel[] parametersREAD_COMMITTED() {
        return new IsolationLevel[]{IsolationLevels.READ_COMMITTED, IsolationLevels.SNAPSHOT_READ, IsolationLevels.SNAPSHOT, IsolationLevels.SERIALIZABLE};
    }

    public RDFSchemaRepositoryConnectionTest(IsolationLevel level) {
        super(level);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.person = this.vf.createIRI("http://xmlns.com/foaf/0.1/Person");
        this.woman = this.vf.createIRI("http://example.org/Woman");
        this.man = this.vf.createIRI("http://example.org/Man");
    }

    @Test
    public void testDomainInference() throws Exception {
        this.testCon.begin();
        this.testCon.add((Resource)this.name, RDFS.DOMAIN, (Value)this.person, new Resource[0]);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testSubClassInference() throws Exception {
        this.testCon.begin();
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.man, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.commit();
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testMakeExplicit() throws Exception {
        this.testCon.begin();
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.commit();
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
        this.testCon.begin();
        this.testCon.add(this.alice, RDF.TYPE, (Value)this.person, new Resource[0]);
        this.testCon.commit();
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    @Test
    public void testExplicitFlag() throws Exception {
        try (RepositoryResult result = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, true, new Resource[0]);){
            Assert.assertTrue((String)"result should not be empty", (boolean)result.hasNext());
        }
        result = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, false, new Resource[0]);
        try {
            Assert.assertFalse((String)"result should be empty", (boolean)result.hasNext());
        }
        finally {
            result.close();
        }
    }

    @Test
    public void testInferencerUpdates() throws Exception {
        this.testCon.begin((IsolationLevel)IsolationLevels.READ_COMMITTED);
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.remove(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.commit();
        Assert.assertFalse((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }

    @Test
    public void testInferencerQueryDuringTransaction() throws Exception {
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.commit();
    }

    @Test
    public void testInferencerTransactionIsolation() throws Exception {
        if (IsolationLevels.NONE.isCompatibleWith(this.level)) {
            return;
        }
        this.testCon.begin();
        this.testCon.add(this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        Assert.assertFalse((boolean)this.testCon2.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.commit();
        Assert.assertTrue((boolean)this.testCon.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        Assert.assertTrue((boolean)this.testCon2.hasStatement(this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }

    @Override
    @Ignore
    @Test
    public void testDefaultContext() throws Exception {
    }

    @Override
    @Ignore
    @Test
    public void testDefaultInsertContext() throws Exception {
    }

    @Override
    @Ignore
    @Test
    public void testExclusiveNullContext() throws Exception {
    }
}

