/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class RepositoryTest {
    @Rule
    public Timeout to = new Timeout(60000);
    private static final String MBOX = "mbox";
    private static final String NAME = "name";
    protected static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    public static final String TEST_DIR_PREFIX = "/testcases/";
    protected Repository testRepository;
    protected ValueFactory vf;
    protected Resource bob;
    protected Resource alice;
    protected Resource alexander;
    protected IRI name;
    protected IRI mbox;
    protected final IRI publisher = DC.PUBLISHER;
    protected IRI unknownContext;
    protected IRI context1;
    protected IRI context2;
    protected Literal nameAlice;
    protected Literal nameBob;
    protected Literal mboxAlice;
    protected Literal mboxBob;
    protected Literal \u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u044a\u0440;

    @Before
    public void setUp() throws Exception {
        this.testRepository = this.createRepository();
        this.testRepository.initialize();
        this.vf = this.testRepository.getValueFactory();
        this.bob = this.vf.createBNode();
        this.alice = this.vf.createBNode();
        this.name = this.vf.createIRI("http://xmlns.com/foaf/0.1/name");
        this.mbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/mbox");
        this.nameAlice = this.vf.createLiteral("Alice");
        this.nameBob = this.vf.createLiteral("Bob");
        this.mboxAlice = this.vf.createLiteral("alice@example.org");
        this.mboxBob = this.vf.createLiteral("bob@example.org");
    }

    @After
    public void tearDown() throws Exception {
        this.testRepository.shutDown();
    }

    protected abstract Repository createRepository() throws Exception;

    @Test
    public void testShutdownFollowedByInit() throws Exception {
        try (RepositoryConnection conn = this.testRepository.getConnection();){
            conn.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertTrue((boolean)conn.hasStatement(this.bob, this.mbox, (Value)this.mboxBob, true, new Resource[0]));
        }
        this.testRepository.shutDown();
        this.testRepository.initialize();
        conn = this.testRepository.getConnection();
        try {
            conn.add(this.bob, this.mbox, (Value)this.mboxBob, new Resource[0]);
            Assert.assertTrue((boolean)conn.hasStatement(this.bob, this.mbox, (Value)this.mboxBob, true, new Resource[0]));
        }
        finally {
            conn.close();
        }
    }
}

