/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.util.HashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SparqlAggregatesTest {
    public String selectNameMbox = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name; foaf:mbox  ?mbox }";
    public String concatMbox = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name (group_concat(?mbox) AS ?mbox)\n WHERE { ?x foaf:name  ?name; foaf:mbox  ?mbox } GROUP BY ?name";
    public String concatOptionalMbox = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name (group_concat(?mbox) AS ?mbox)\n WHERE { ?x foaf:name  ?name OPTIONAL { ?x foaf:mbox  ?mbox } } GROUP BY ?name";
    public String countMbox = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name (count(?mbox) AS ?mbox)\n WHERE { ?x foaf:name  ?name; foaf:mbox  ?mbox } GROUP BY ?name";
    public String countOptionalMbox = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name (count(?mb) AS ?mbox)\n WHERE { ?x foaf:name  ?name OPTIONAL { ?x foaf:mbox  ?mb } } GROUP BY ?name";
    private Repository repository;
    private RepositoryConnection conn;
    private ValueFactory vf;

    @Test
    public void testSelect() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.selectNameMbox);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        result.next();
        result.next();
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testConcat() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.concatMbox);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertNotNull((Object)((BindingSet)result.next()).getValue("mbox"));
        Assert.assertNotNull((Object)((BindingSet)result.next()).getValue("mbox"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testConcatOptional() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.concatOptionalMbox);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        result.next();
        result.next();
        result.next();
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testCount() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.countMbox);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)"1", (Object)((BindingSet)result.next()).getValue("mbox").stringValue());
        Assert.assertEquals((Object)"1", (Object)((BindingSet)result.next()).getValue("mbox").stringValue());
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testCountOptional() throws Exception {
        HashSet<String> zeroOr1 = new HashSet<String>();
        zeroOr1.add("0");
        zeroOr1.add("1");
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.countOptionalMbox);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertTrue((boolean)zeroOr1.contains(((BindingSet)result.next()).getValue("mbox").stringValue()));
        Assert.assertTrue((boolean)zeroOr1.contains(((BindingSet)result.next()).getValue("mbox").stringValue()));
        Assert.assertTrue((boolean)zeroOr1.contains(((BindingSet)result.next()).getValue("mbox").stringValue()));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.vf = this.repository.getValueFactory();
        this.createUser("james", "James Leigh", "james@leigh");
        this.createUser("megan", "Megan Leigh", "megan@leigh");
        this.createUser("hunt", "James Leigh Hunt", null);
        this.conn = this.repository.getConnection();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }

    private void createUser(String id, String name, String email) throws RepositoryException {
        RepositoryConnection conn = this.repository.getConnection();
        IRI subj = this.vf.createIRI("http://example.org/ns#", id);
        IRI foafName = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "name");
        IRI foafMbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "mbox");
        conn.add((Resource)subj, foafName, (Value)this.vf.createLiteral(name), new Resource[0]);
        if (email != null) {
            conn.add((Resource)subj, foafMbox, (Value)this.vf.createIRI("mailto:", email), new Resource[0]);
        }
        conn.close();
    }
}

