/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SparqlDatasetTest {
    public String queryNoFrom = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT (COUNT(DISTINCT ?name) as ?c) \n WHERE { ?x foaf:name  ?name . } ";
    public String queryWithFrom = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT (COUNT(DISTINCT ?name) as ?c) \n FROM <http://example.org/graph1>  WHERE { ?x foaf:name  ?name . } ";
    private Repository repository;
    private RepositoryConnection conn;
    private ValueFactory vf;
    private SimpleDataset dataset;
    private IRI graph1;
    private IRI george;
    private IRI paul;
    private IRI john;
    private IRI ringo;

    @Test
    public void testNoFrom() throws Exception {
        Literal count;
        BindingSet bs;
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryNoFrom);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        if (result.hasNext()) {
            bs = (BindingSet)result.next();
            Assert.assertFalse((boolean)result.hasNext());
            count = (Literal)bs.getValue("c");
            Assert.assertEquals((long)4L, (long)count.intValue());
        }
        result.close();
        query.setDataset((Dataset)this.dataset);
        result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        if (result.hasNext()) {
            bs = (BindingSet)result.next();
            Assert.assertFalse((boolean)result.hasNext());
            count = (Literal)bs.getValue("c");
            Assert.assertEquals((long)2L, (long)count.intValue());
        }
        result.close();
    }

    @Test
    public void testWithFrom() throws Exception {
        Literal count;
        BindingSet bs;
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryWithFrom);
        TupleQueryResult result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        if (result.hasNext()) {
            bs = (BindingSet)result.next();
            Assert.assertFalse((boolean)result.hasNext());
            count = (Literal)bs.getValue("c");
            Assert.assertEquals((long)2L, (long)count.intValue());
        }
        result.close();
        query.setDataset((Dataset)this.dataset);
        result = query.evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        if (result.hasNext()) {
            bs = (BindingSet)result.next();
            Assert.assertFalse((boolean)result.hasNext());
            count = (Literal)bs.getValue("c");
            Assert.assertEquals((long)2L, (long)count.intValue());
        }
        result.close();
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.vf = this.repository.getValueFactory();
        this.graph1 = this.vf.createIRI("http://example.org/graph1");
        this.john = this.createUser("john", "John Lennon", "john@example.org", new Resource[0]);
        this.paul = this.createUser("paul", "Paul McCartney", "paul@example.org", new Resource[0]);
        this.george = this.createUser("george", "George Harrison", "george@example.org", new Resource[]{this.graph1});
        this.ringo = this.createUser("ringo", "Ringo Starr", "ringo@example.org", new Resource[]{this.graph1});
        this.conn = this.repository.getConnection();
        this.dataset = new SimpleDataset();
        this.dataset.addDefaultGraph(this.graph1);
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }

    private IRI createUser(String id, String name, String email, Resource ... context) throws RepositoryException {
        RepositoryConnection conn = this.repository.getConnection();
        IRI subj = this.vf.createIRI("http://example.org/ns#", id);
        IRI foafName = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "name");
        IRI foafMbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "mbox");
        conn.add((Resource)subj, RDF.TYPE, (Value)this.vf.createIRI("http://xmlns.com/foaf/0.1/", "Person"), context);
        conn.add((Resource)subj, foafName, (Value)this.vf.createLiteral(name), context);
        conn.add((Resource)subj, foafMbox, (Value)this.vf.createIRI("mailto:", email), context);
        conn.close();
        return subj;
    }
}

