/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SparqlOrderByTest {
    private String query1 = "PREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nSELECT ?name\nWHERE { ?x foaf:name ?name }\nORDER BY ?name\n";
    private String query2 = "PREFIX     :    <http://example.org/ns#>\nPREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nPREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>\nSELECT ?name\nWHERE { ?x foaf:name ?name ; :empId ?emp }\nORDER BY DESC(?emp)\n";
    private String query3 = "PREFIX     :    <http://example.org/ns#>\nPREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nSELECT ?name\nWHERE { ?x foaf:name ?name ; :empId ?emp }\nORDER BY ?name DESC(?emp)\n";
    private Repository repository;
    private RepositoryConnection conn;

    @Test
    public void testQuery1() throws Exception {
        Assert.assertTrue(("James Leigh".compareTo("James Leigh Hunt") < 0 ? 1 : 0) != 0);
        this.assertResult(this.query1, Arrays.asList("James Leigh", "James Leigh", "James Leigh Hunt", "Megan Leigh"));
    }

    @Test
    public void testQuery2() throws Exception {
        this.assertResult(this.query2, Arrays.asList("Megan Leigh", "James Leigh", "James Leigh Hunt", "James Leigh"));
    }

    @Test
    public void testQuery3() throws Exception {
        this.assertResult(this.query3, Arrays.asList("James Leigh", "James Leigh", "James Leigh Hunt", "Megan Leigh"));
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.createEmployee("james", "James Leigh", 123);
        this.createEmployee("jim", "James Leigh", 244);
        this.createEmployee("megan", "Megan Leigh", 1234);
        this.createEmployee("hunt", "James Leigh Hunt", 243);
        this.conn = this.repository.getConnection();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }

    private void createEmployee(String id, String name, int empId) throws RepositoryException {
        ValueFactory vf = this.repository.getValueFactory();
        String foafName = "http://xmlns.com/foaf/0.1/name";
        String exEmpId = "http://example.org/ns#empId";
        RepositoryConnection conn = this.repository.getConnection();
        conn.add((Resource)vf.createIRI("http://example.org/ns#" + id), vf.createIRI(foafName), (Value)vf.createLiteral(name), new Resource[0]);
        conn.add((Resource)vf.createIRI("http://example.org/ns#" + id), vf.createIRI(exEmpId), (Value)vf.createLiteral(empId), new Resource[0]);
        conn.close();
    }

    private void assertResult(String queryStr, List<String> names) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
        TupleQueryResult result = query.evaluate();
        for (String name : names) {
            Value value = ((BindingSet)result.next()).getValue("name");
            Assert.assertEquals((Object)name, (Object)((Literal)value).getLabel());
        }
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }
}

