/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SparqlRegexTest {
    public String queryInline = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), \"@Work.example\", \"i\") }";
    public String queryBinding = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), ?pattern) }";
    public String queryBindingFlags = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), ?pattern, ?flags) }";
    public String queryExpr = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         ?y <http://example.org/ns#pattern>  ?pattern .\n         ?y <http://example.org/ns#flags>  ?flags .\n         FILTER regex(str(?mbox), ?pattern, ?flags) }";
    private Repository repository;
    private RepositoryConnection conn;
    private ValueFactory vf;
    private Literal hunt;

    @Test
    public void testInline() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryInline);
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.hunt, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testBinding() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBinding);
        query.setBinding("pattern", (Value)this.vf.createLiteral("@work.example"));
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.hunt, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testBindingFlags() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBindingFlags);
        query.setBinding("pattern", (Value)this.vf.createLiteral("@Work.example"));
        query.setBinding("flags", (Value)this.vf.createLiteral("i"));
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.hunt, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testExpr() throws Exception {
        IRI pattern = this.vf.createIRI("http://example.org/ns#", "pattern");
        IRI flags = this.vf.createIRI("http://example.org/ns#", "flags");
        BNode bnode = this.vf.createBNode();
        this.conn.add((Resource)bnode, pattern, (Value)this.vf.createLiteral("@Work.example"), new Resource[0]);
        this.conn.add((Resource)bnode, flags, (Value)this.vf.createLiteral("i"), new Resource[0]);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryExpr);
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.hunt, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.vf = this.repository.getValueFactory();
        this.hunt = this.vf.createLiteral("James Leigh Hunt");
        this.createUser("james", "James Leigh", "james@leigh");
        this.createUser("megan", "Megan Leigh", "megan@leigh");
        this.createUser("hunt", "James Leigh Hunt", "james@work.example");
        this.conn = this.repository.getConnection();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }

    private void createUser(String id, String name, String email) throws RepositoryException {
        RepositoryConnection conn = this.repository.getConnection();
        IRI subj = this.vf.createIRI("http://example.org/ns#", id);
        IRI foafName = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "name");
        IRI foafMbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "mbox");
        conn.add((Resource)subj, foafName, (Value)this.vf.createLiteral(name), new Resource[0]);
        conn.add((Resource)subj, foafMbox, (Value)this.vf.createIRI("mailto:", email), new Resource[0]);
        conn.close();
    }
}

