/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SparqlSetBindingTest {
    public String queryBinding = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n } ";
    public String queryBindingSubselect = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n        { SELECT ?x WHERE { ?x a foaf:Person } } } ";
    private Repository repository;
    private RepositoryConnection conn;
    private ValueFactory vf;
    private Literal ringo;
    private IRI ringoRes;

    @Test
    public void testBinding() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBinding);
        query.setBinding("name", (Value)this.ringo);
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.ringo, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void testBindingSubselect() throws Exception {
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBindingSubselect);
        query.setBinding("x", (Value)this.ringoRes);
        TupleQueryResult result = query.evaluate();
        Assert.assertEquals((Object)this.ringo, (Object)((BindingSet)result.next()).getValue("name"));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Before
    public void setUp() throws Exception {
        this.repository = this.createRepository();
        this.vf = this.repository.getValueFactory();
        this.ringo = this.vf.createLiteral("Ringo Starr");
        this.ringoRes = this.vf.createIRI("http://example.org/ns#", "ringo");
        this.createUser("john", "John Lennon", "john@example.org");
        this.createUser("paul", "Paul McCartney", "paul@example.org");
        this.createUser("ringo", "Ringo Starr", "ringo@example.org");
        this.conn = this.repository.getConnection();
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.conn.close();
        this.conn = null;
        this.repository.shutDown();
        this.repository = null;
    }

    private void createUser(String id, String name, String email) throws RepositoryException {
        RepositoryConnection conn = this.repository.getConnection();
        IRI subj = this.vf.createIRI("http://example.org/ns#", id);
        IRI foafName = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "name");
        IRI foafMbox = this.vf.createIRI("http://xmlns.com/foaf/0.1/", "mbox");
        conn.add((Resource)subj, RDF.TYPE, (Value)this.vf.createIRI("http://xmlns.com/foaf/0.1/", "Person"), new Resource[0]);
        conn.add((Resource)subj, foafName, (Value)this.vf.createLiteral(name), new Resource[0]);
        conn.add((Resource)subj, foafMbox, (Value)this.vf.createIRI("mailto:", email), new Resource[0]);
        conn.close();
    }
}

