/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TupleQueryResultTest {
    private Repository rep;
    private RepositoryConnection con;
    private String emptyResultQuery;
    private String singleResultQuery;
    private String multipleResultQuery;

    @Before
    public void setUp() throws Exception {
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.buildQueries();
        this.addData();
    }

    @After
    public void tearDown() throws Exception {
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection con = repository.getConnection();
        con.clear(new Resource[0]);
        con.clearNamespaces();
        con.close();
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    private void buildQueries() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * ");
        query.append("FROM {X} P {Y} ");
        query.append("WHERE X != X ");
        this.emptyResultQuery = query.toString();
        query = new StringBuilder();
        query.append("SELECT DISTINCT P ");
        query.append("FROM {} dc:publisher {P} ");
        query.append("USING NAMESPACE ");
        query.append("   dc = <http://purl.org/dc/elements/1.1/>");
        this.singleResultQuery = query.toString();
        query = new StringBuilder();
        query.append("SELECT DISTINCT P, D ");
        query.append("FROM {} dc:publisher {P}; ");
        query.append("        dc:date {D} ");
        query.append("USING NAMESPACE ");
        query.append("   dc = <http://purl.org/dc/elements/1.1/>");
        this.multipleResultQuery = query.toString();
    }

    private void addData() throws IOException, UnsupportedRDFormatException, RDFParseException, RepositoryException {
        try (InputStream defaultGraph = TupleQueryResultTest.class.getResourceAsStream("/testcases/default-graph-1.ttl");){
            this.con.add(defaultGraph, "", RDFFormat.TURTLE, new Resource[0]);
        }
    }

    @Test
    public void testGetBindingNames() throws Exception {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.multipleResultQuery).evaluate();){
            List headers = result.getBindingNames();
            Assert.assertThat((String)"first header element", headers.get(0), (Matcher)CoreMatchers.is((Object)"P"));
            Assert.assertThat((String)"second header element", headers.get(1), (Matcher)CoreMatchers.is((Object)"D"));
        }
    }

    @Test
    public void testIterator() throws Exception {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.multipleResultQuery).evaluate();){
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertTrue((String)"query should have multiple results.", (count > 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIsEmpty() throws Exception {
        try (TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SERQL, this.emptyResultQuery).evaluate();){
            Assert.assertFalse((String)"Query result should be empty", (boolean)result.hasNext());
        }
    }
}

