/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.optimistic;

import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.OptimisticIsolationTest;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeadLockTest {
    private Repository repo;
    private RepositoryConnection a;
    private RepositoryConnection b;
    private IsolationLevel level = IsolationLevels.SNAPSHOT_READ;
    private String NS = "http://rdf.example.org/";
    private URI PAINTER;
    private URI PICASSO;
    private URI REMBRANDT;

    @Before
    public void setUp() throws Exception {
        this.repo = OptimisticIsolationTest.getEmptyInitializedRepository(DeadLockTest.class);
        ValueFactory uf = this.repo.getValueFactory();
        this.PAINTER = uf.createURI(this.NS, "Painter");
        this.PICASSO = uf.createURI(this.NS, "picasso");
        this.REMBRANDT = uf.createURI(this.NS, "rembrandt");
        this.a = this.repo.getConnection();
        this.b = this.repo.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.a.close();
        this.b.close();
        this.repo.shutDown();
    }

    @Test
    public void test() throws Exception {
        final CountDownLatch start = new CountDownLatch(2);
        final CountDownLatch end = new CountDownLatch(2);
        final CountDownLatch commit = new CountDownLatch(1);
        final Exception e1 = new Exception();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    start.countDown();
                    DeadLockTest.this.a.begin(DeadLockTest.this.level);
                    DeadLockTest.this.a.add((Resource)DeadLockTest.this.PICASSO, RDF.TYPE, (Value)DeadLockTest.this.PAINTER, new Resource[0]);
                    commit.await();
                    DeadLockTest.this.a.commit();
                }
                catch (Exception e) {
                    e1.initCause(e);
                }
                finally {
                    end.countDown();
                }
            }
        }).start();
        final Exception e2 = new Exception();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    start.countDown();
                    DeadLockTest.this.b.begin(DeadLockTest.this.level);
                    DeadLockTest.this.b.add((Resource)DeadLockTest.this.REMBRANDT, RDF.TYPE, (Value)DeadLockTest.this.PAINTER, new Resource[0]);
                    commit.await();
                    DeadLockTest.this.b.commit();
                }
                catch (Exception e) {
                    e2.initCause(e);
                }
                finally {
                    end.countDown();
                }
            }
        }).start();
        start.await();
        commit.countDown();
        Thread.sleep(500L);
        end.await();
        Assert.assertNull((Object)e1.getCause());
        Assert.assertNull((Object)e2.getCause());
    }
}

