/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.optimistic;

import java.net.URL;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.OptimisticIsolationTest;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeleteInsertTest {
    private Repository repo;
    private String NS = "http://example.org/";
    private RepositoryConnection con;
    private IsolationLevel level = IsolationLevels.SNAPSHOT_READ;
    private ClassLoader cl = this.getClass().getClassLoader();

    @Before
    public void setUp() throws Exception {
        this.repo = OptimisticIsolationTest.getEmptyInitializedRepository(DeleteInsertTest.class);
        this.con = this.repo.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.con.close();
        this.repo.shutDown();
    }

    @Test
    public void test() throws Exception {
        String load = IOUtil.readString((URL)this.cl.getResource("test/insert-data.ru"));
        this.con.prepareUpdate(QueryLanguage.SPARQL, load, this.NS).execute();
        this.con.begin(this.level);
        String modify = IOUtil.readString((URL)this.cl.getResource("test/delete-insert.ru"));
        this.con.prepareUpdate(QueryLanguage.SPARQL, modify, this.NS).execute();
        this.con.commit();
        String ask = IOUtil.readString((URL)this.cl.getResource("test/ask.rq"));
        Assert.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, ask, this.NS).evaluate());
    }
}

