/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.optimistic;

import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.OptimisticIsolationTest;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModificationTest {
    private Repository repo;
    private RepositoryConnection con;
    private IsolationLevel level = IsolationLevels.SNAPSHOT_READ;
    private String NS = "http://rdf.example.org/";
    private URI PAINTER;
    private URI PICASSO;

    @Before
    public void setUp() throws Exception {
        this.repo = OptimisticIsolationTest.getEmptyInitializedRepository(ModificationTest.class);
        ValueFactory uf = this.repo.getValueFactory();
        this.PAINTER = uf.createURI(this.NS, "Painter");
        this.PICASSO = uf.createURI(this.NS, "picasso");
        this.con = this.repo.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.con.close();
        this.repo.shutDown();
    }

    @Test
    public void testAdd() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.con.commit();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testAutoCommit() throws Exception {
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.con.close();
        this.con = this.repo.getConnection();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testInsertData() throws Exception {
        this.con.begin(this.level);
        this.con.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA { <picasso> a <Painter> }", this.NS).execute();
        this.con.commit();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testInsertDataAutoCommit() throws Exception {
        this.con.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA { <picasso> a <Painter> }", this.NS).execute();
        this.con.close();
        this.con = this.repo.getConnection();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testRemove() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.con.commit();
        this.con.begin(this.level);
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testAddIn() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
    }

    @Test
    public void testRemoveFrom() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        this.con.begin(this.level);
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
    }

    @Test
    public void testMove() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        this.con.begin(this.level);
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PAINTER});
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PAINTER}));
    }

    @Test
    public void testMoveOut() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        this.con.begin(this.level);
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[0]);
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[0]));
    }

    @Test
    public void testCancel() throws Exception {
        this.con.begin(this.level);
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO});
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
    }

    @Test
    public void testRemoveDuplicate() throws Exception {
        this.con.add((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PICASSO, this.PAINTER});
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PAINTER}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
        this.con.begin(this.level);
        this.con.remove((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, new Resource[]{this.PAINTER});
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PAINTER}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
        Assert.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK {<" + this.PICASSO + "> a <" + this.PAINTER + ">}").evaluate());
        this.con.commit();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PAINTER}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.PICASSO, RDF.TYPE, (Value)this.PAINTER, false, new Resource[]{this.PICASSO}));
        Assert.assertTrue((boolean)this.con.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK {<" + this.PICASSO + "> a <" + this.PAINTER + ">}").evaluate());
    }
}

